package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialCostTypeAdjustBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialCostTypeAdjustBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-09
 */
@RestController
public class FinancialCostTypeAdjustBillDetailController {

  @Autowired
  private IFinancialCostTypeAdjustBillDetailService financialCostTypeAdjustBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialCostTypeAdjustBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialcosttypeadjustbilldetails" )
  public XfR getFinancialCostTypeAdjustBillDetails(XfPage page, FinancialCostTypeAdjustBillDetail financialCostTypeAdjustBillDetail) {
    return XfR.ok(financialCostTypeAdjustBillDetailServiceImpl.page(page, Wrappers.query(financialCostTypeAdjustBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialcosttypeadjustbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialCostTypeAdjustBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialCostTypeAdjustBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialcosttypeadjustbilldetails")
  public XfR save(@RequestBody FinancialCostTypeAdjustBillDetail financialCostTypeAdjustBillDetail) {
     return XfR.ok(financialCostTypeAdjustBillDetailServiceImpl.save(financialCostTypeAdjustBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialCostTypeAdjustBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialcosttypeadjustbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialCostTypeAdjustBillDetail financialCostTypeAdjustBillDetail,@PathVariable Long id) {
      financialCostTypeAdjustBillDetail.setId(id);
      return XfR.ok(financialCostTypeAdjustBillDetailServiceImpl.updateById(financialCostTypeAdjustBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialCostTypeAdjustBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialcosttypeadjustbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialCostTypeAdjustBillDetail financialCostTypeAdjustBillDetail,@PathVariable Long id) {
      FinancialCostTypeAdjustBillDetail upfinancialCostTypeAdjustBillDetail = financialCostTypeAdjustBillDetailServiceImpl.getById(id);
      if(upfinancialCostTypeAdjustBillDetail != null){
        upfinancialCostTypeAdjustBillDetail = ObjectCopyUtils.copyProperties(financialCostTypeAdjustBillDetail,upfinancialCostTypeAdjustBillDetail,true);
      }
      return XfR.ok(financialCostTypeAdjustBillDetailServiceImpl.updateById(upfinancialCostTypeAdjustBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialcosttypeadjustbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialCostTypeAdjustBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialcosttypeadjustbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_cost_type_adjust_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialCostTypeAdjustBillDetailServiceImpl.querys(params));
  }

}
