package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialPurchAsassetBorrowBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialPurchAsassetBorrowBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-09
 */
@RestController
public class FinancialPurchAsassetBorrowBillController {

  @Autowired
  private IFinancialPurchAsassetBorrowBillService financialPurchAsassetBorrowBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPurchAsassetBorrowBill ${table.comment}
   * @return
   */
  @GetMapping("/financialpurchasassetborrowbills" )
  public XfR getFinancialPurchAsassetBorrowBills(XfPage page, FinancialPurchAsassetBorrowBill financialPurchAsassetBorrowBill) {
    return XfR.ok(financialPurchAsassetBorrowBillServiceImpl.page(page, Wrappers.query(financialPurchAsassetBorrowBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpurchasassetborrowbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPurchAsassetBorrowBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialPurchAsassetBorrowBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialpurchasassetborrowbills")
  public XfR save(@RequestBody FinancialPurchAsassetBorrowBill financialPurchAsassetBorrowBill) {
     return XfR.ok(financialPurchAsassetBorrowBillServiceImpl.save(financialPurchAsassetBorrowBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialPurchAsassetBorrowBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialpurchasassetborrowbills/{id}")
  public XfR putUpdate(@RequestBody FinancialPurchAsassetBorrowBill financialPurchAsassetBorrowBill,@PathVariable Long id) {
      financialPurchAsassetBorrowBill.setId(id);
      return XfR.ok(financialPurchAsassetBorrowBillServiceImpl.updateById(financialPurchAsassetBorrowBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialPurchAsassetBorrowBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialpurchasassetborrowbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialPurchAsassetBorrowBill financialPurchAsassetBorrowBill,@PathVariable Long id) {
      FinancialPurchAsassetBorrowBill upfinancialPurchAsassetBorrowBill = financialPurchAsassetBorrowBillServiceImpl.getById(id);
      if(upfinancialPurchAsassetBorrowBill != null){
        upfinancialPurchAsassetBorrowBill = ObjectCopyUtils.copyProperties(financialPurchAsassetBorrowBill,upfinancialPurchAsassetBorrowBill,true);
      }
      return XfR.ok(financialPurchAsassetBorrowBillServiceImpl.updateById(upfinancialPurchAsassetBorrowBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpurchasassetborrowbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPurchAsassetBorrowBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialpurchasassetborrowbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_purch_asasset_borrow_bill");
     params.put("request", condition);

     return XfR.ok(financialPurchAsassetBorrowBillServiceImpl.querys(params));
  }

}
