package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialAccessoriesrReplaceBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialAccessoriesrReplaceBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-09
 */
@RestController
public class FinancialAccessoriesrReplaceBillController {

  @Autowired
  private IFinancialAccessoriesrReplaceBillService financialAccessoriesrReplaceBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialAccessoriesrReplaceBill ${table.comment}
   * @return
   */
  @GetMapping("/financialaccessoriesrreplacebills" )
  public XfR getFinancialAccessoriesrReplaceBills(XfPage page, FinancialAccessoriesrReplaceBill financialAccessoriesrReplaceBill) {
    return XfR.ok(financialAccessoriesrReplaceBillServiceImpl.page(page, Wrappers.query(financialAccessoriesrReplaceBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialaccessoriesrreplacebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialAccessoriesrReplaceBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialAccessoriesrReplaceBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialaccessoriesrreplacebills")
  public XfR save(@RequestBody FinancialAccessoriesrReplaceBill financialAccessoriesrReplaceBill) {
     return XfR.ok(financialAccessoriesrReplaceBillServiceImpl.save(financialAccessoriesrReplaceBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialAccessoriesrReplaceBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialaccessoriesrreplacebills/{id}")
  public XfR putUpdate(@RequestBody FinancialAccessoriesrReplaceBill financialAccessoriesrReplaceBill,@PathVariable Long id) {
      financialAccessoriesrReplaceBill.setId(id);
      return XfR.ok(financialAccessoriesrReplaceBillServiceImpl.updateById(financialAccessoriesrReplaceBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialAccessoriesrReplaceBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialaccessoriesrreplacebills/{id}")
  public XfR patchUpdate(@RequestBody FinancialAccessoriesrReplaceBill financialAccessoriesrReplaceBill,@PathVariable Long id) {
      FinancialAccessoriesrReplaceBill upfinancialAccessoriesrReplaceBill = financialAccessoriesrReplaceBillServiceImpl.getById(id);
      if(upfinancialAccessoriesrReplaceBill != null){
        upfinancialAccessoriesrReplaceBill = ObjectCopyUtils.copyProperties(financialAccessoriesrReplaceBill,upfinancialAccessoriesrReplaceBill,true);
      }
      return XfR.ok(financialAccessoriesrReplaceBillServiceImpl.updateById(upfinancialAccessoriesrReplaceBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialaccessoriesrreplacebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialAccessoriesrReplaceBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialaccessoriesrreplacebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_accessoriesr_replace_bill");
     params.put("request", condition);

     return XfR.ok(financialAccessoriesrReplaceBillServiceImpl.querys(params));
  }

}
