package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialInvoicePledgeBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialInvoicePledgeBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-09
 */
@RestController
public class FinancialInvoicePledgeBillDetailController {

  @Autowired
  private IFinancialInvoicePledgeBillDetailService financialInvoicePledgeBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialInvoicePledgeBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialinvoicepledgebilldetails" )
  public XfR getFinancialInvoicePledgeBillDetails(XfPage page, FinancialInvoicePledgeBillDetail financialInvoicePledgeBillDetail) {
    return XfR.ok(financialInvoicePledgeBillDetailServiceImpl.page(page, Wrappers.query(financialInvoicePledgeBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialinvoicepledgebilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialInvoicePledgeBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialInvoicePledgeBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialinvoicepledgebilldetails")
  public XfR save(@RequestBody FinancialInvoicePledgeBillDetail financialInvoicePledgeBillDetail) {
     return XfR.ok(financialInvoicePledgeBillDetailServiceImpl.save(financialInvoicePledgeBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialInvoicePledgeBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialinvoicepledgebilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialInvoicePledgeBillDetail financialInvoicePledgeBillDetail,@PathVariable Long id) {
      financialInvoicePledgeBillDetail.setId(id);
      return XfR.ok(financialInvoicePledgeBillDetailServiceImpl.updateById(financialInvoicePledgeBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialInvoicePledgeBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialinvoicepledgebilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialInvoicePledgeBillDetail financialInvoicePledgeBillDetail,@PathVariable Long id) {
      FinancialInvoicePledgeBillDetail upfinancialInvoicePledgeBillDetail = financialInvoicePledgeBillDetailServiceImpl.getById(id);
      if(upfinancialInvoicePledgeBillDetail != null){
        upfinancialInvoicePledgeBillDetail = ObjectCopyUtils.copyProperties(financialInvoicePledgeBillDetail,upfinancialInvoicePledgeBillDetail,true);
      }
      return XfR.ok(financialInvoicePledgeBillDetailServiceImpl.updateById(upfinancialInvoicePledgeBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialinvoicepledgebilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialInvoicePledgeBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialinvoicepledgebilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_invoice_pledge_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialInvoicePledgeBillDetailServiceImpl.querys(params));
  }

}
