package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.MultiRelation;
import com.xforceplus.ultraman.app.financialsettlement.service.IMultiRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-23
 */
@RestController
public class MultiRelationController {

  @Autowired
  private IMultiRelationService multiRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param multiRelation ${table.comment}
   * @return
   */
  @GetMapping("/multirelations" )
  public XfR getMultiRelations(XfPage page, MultiRelation multiRelation) {
    return XfR.ok(multiRelationServiceImpl.page(page, Wrappers.query(multiRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/multirelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(multiRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param multiRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/multirelations")
  public XfR save(@RequestBody MultiRelation multiRelation) {
     return XfR.ok(multiRelationServiceImpl.save(multiRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param multiRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/multirelations/{id}")
  public XfR putUpdate(@RequestBody MultiRelation multiRelation,@PathVariable Long id) {
      multiRelation.setId(id);
      return XfR.ok(multiRelationServiceImpl.updateById(multiRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param multiRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/multirelations/{id}")
  public XfR patchUpdate(@RequestBody MultiRelation multiRelation,@PathVariable Long id) {
      MultiRelation upmultiRelation = multiRelationServiceImpl.getById(id);
      if(upmultiRelation != null){
        upmultiRelation = ObjectCopyUtils.copyProperties(multiRelation,upmultiRelation,true);
      }
      return XfR.ok(multiRelationServiceImpl.updateById(upmultiRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/multirelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(multiRelationServiceImpl.removeById(id));
  }

  @PostMapping("/multirelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "multi_relation");
     params.put("request", condition);

     return XfR.ok(multiRelationServiceImpl.querys(params));
  }

}
