package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ServiceCost;
import com.xforceplus.ultraman.app.financialsettlement.service.IServiceCostService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 服务成本主信息前端控制器
 *
 * @author ultraman
 * @date 2022-06-23
 */
@RestController
public class ServiceCostController {

  @Autowired
  private IServiceCostService serviceCostServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param serviceCost 服务成本主信息
   * @return
   */
  @GetMapping("/servicecosts" )
  public XfR getServiceCosts(XfPage page, ServiceCost serviceCost) {
    return XfR.ok(serviceCostServiceImpl.page(page, Wrappers.query(serviceCost)));
  }

  /**
   * 通过id查询服务成本主信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/servicecosts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(serviceCostServiceImpl.getById(id));
  }

  /**
   * 新增服务成本主信息
   * @param serviceCost 服务成本主信息
   * @return XfR
   */
  @PostMapping("/servicecosts")
  public XfR save(@RequestBody ServiceCost serviceCost) {
     return XfR.ok(serviceCostServiceImpl.save(serviceCost));
  }

  /**
   * 修改-传入修改后的全部数据服务成本主信息
   * @param serviceCost 服务成本主信息
   * @return XfR
   */
  @PutMapping("/servicecosts/{id}")
  public XfR putUpdate(@RequestBody ServiceCost serviceCost,@PathVariable Long id) {
      serviceCost.setId(id);
      return XfR.ok(serviceCostServiceImpl.updateById(serviceCost));
  }

  /**
   * 修改-传入修改的数据服务成本主信息
   * @param serviceCost 服务成本主信息
   * @return XfR
   */
  @PatchMapping("/servicecosts/{id}")
  public XfR patchUpdate(@RequestBody ServiceCost serviceCost,@PathVariable Long id) {
      ServiceCost upserviceCost = serviceCostServiceImpl.getById(id);
      if(upserviceCost != null){
        upserviceCost = ObjectCopyUtils.copyProperties(serviceCost,upserviceCost,true);
      }
      return XfR.ok(serviceCostServiceImpl.updateById(upserviceCost));
  }

  /**
   * 通过id删除服务成本主信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/servicecosts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(serviceCostServiceImpl.removeById(id));
  }

  @PostMapping("/servicecosts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "service_cost");
     params.put("request", condition);

     return XfR.ok(serviceCostServiceImpl.querys(params));
  }

}
