package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialPurchaseBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialPurchaseBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-08
 */
@RestController
public class FinancialPurchaseBillDetailController {

  @Autowired
  private IFinancialPurchaseBillDetailService financialPurchaseBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPurchaseBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialpurchasebilldetails" )
  public XfR getFinancialPurchaseBillDetails(XfPage page, FinancialPurchaseBillDetail financialPurchaseBillDetail) {
    return XfR.ok(financialPurchaseBillDetailServiceImpl.page(page, Wrappers.query(financialPurchaseBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpurchasebilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialPurchaseBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialpurchasebilldetails")
  public XfR save(@RequestBody FinancialPurchaseBillDetail financialPurchaseBillDetail) {
     return XfR.ok(financialPurchaseBillDetailServiceImpl.save(financialPurchaseBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialPurchaseBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialpurchasebilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialPurchaseBillDetail financialPurchaseBillDetail,@PathVariable Long id) {
      financialPurchaseBillDetail.setId(id);
      return XfR.ok(financialPurchaseBillDetailServiceImpl.updateById(financialPurchaseBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialPurchaseBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialpurchasebilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialPurchaseBillDetail financialPurchaseBillDetail,@PathVariable Long id) {
      FinancialPurchaseBillDetail upfinancialPurchaseBillDetail = financialPurchaseBillDetailServiceImpl.getById(id);
      if(upfinancialPurchaseBillDetail != null){
        upfinancialPurchaseBillDetail = ObjectCopyUtils.copyProperties(financialPurchaseBillDetail,upfinancialPurchaseBillDetail,true);
      }
      return XfR.ok(financialPurchaseBillDetailServiceImpl.updateById(upfinancialPurchaseBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpurchasebilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialpurchasebilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_purchase_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialPurchaseBillDetailServiceImpl.querys(params));
  }

}
