package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.NbBankTradeDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.INbBankTradeDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-08
 */
@RestController
public class NbBankTradeDetailController {

  @Autowired
  private INbBankTradeDetailService nbBankTradeDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param nbBankTradeDetail ${table.comment}
   * @return
   */
  @GetMapping("/nbbanktradedetails" )
  public XfR getNbBankTradeDetails(XfPage page, NbBankTradeDetail nbBankTradeDetail) {
    return XfR.ok(nbBankTradeDetailServiceImpl.page(page, Wrappers.query(nbBankTradeDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/nbbanktradedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(nbBankTradeDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param nbBankTradeDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/nbbanktradedetails")
  public XfR save(@RequestBody NbBankTradeDetail nbBankTradeDetail) {
     return XfR.ok(nbBankTradeDetailServiceImpl.save(nbBankTradeDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param nbBankTradeDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/nbbanktradedetails/{id}")
  public XfR putUpdate(@RequestBody NbBankTradeDetail nbBankTradeDetail,@PathVariable Long id) {
      nbBankTradeDetail.setId(id);
      return XfR.ok(nbBankTradeDetailServiceImpl.updateById(nbBankTradeDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param nbBankTradeDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/nbbanktradedetails/{id}")
  public XfR patchUpdate(@RequestBody NbBankTradeDetail nbBankTradeDetail,@PathVariable Long id) {
      NbBankTradeDetail upnbBankTradeDetail = nbBankTradeDetailServiceImpl.getById(id);
      if(upnbBankTradeDetail != null){
        upnbBankTradeDetail = ObjectCopyUtils.copyProperties(nbBankTradeDetail,upnbBankTradeDetail,true);
      }
      return XfR.ok(nbBankTradeDetailServiceImpl.updateById(upnbBankTradeDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/nbbanktradedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(nbBankTradeDetailServiceImpl.removeById(id));
  }

  @PostMapping("/nbbanktradedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "nb_bank_trade_detail");
     params.put("request", condition);

     return XfR.ok(nbBankTradeDetailServiceImpl.querys(params));
  }

}
