package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.StandingBook;
import com.xforceplus.ultraman.app.financialsettlement.service.IStandingBookService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-08
 */
@RestController
public class StandingBookController {

  @Autowired
  private IStandingBookService standingBookServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param standingBook ${table.comment}
   * @return
   */
  @GetMapping("/standingbooks" )
  public XfR getStandingBooks(XfPage page, StandingBook standingBook) {
    return XfR.ok(standingBookServiceImpl.page(page, Wrappers.query(standingBook)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/standingbooks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(standingBookServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param standingBook ${table.comment}
   * @return XfR
   */
  @PostMapping("/standingbooks")
  public XfR save(@RequestBody StandingBook standingBook) {
     return XfR.ok(standingBookServiceImpl.save(standingBook));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param standingBook ${table.comment}
   * @return XfR
   */
  @PutMapping("/standingbooks/{id}")
  public XfR putUpdate(@RequestBody StandingBook standingBook,@PathVariable Long id) {
      standingBook.setId(id);
      return XfR.ok(standingBookServiceImpl.updateById(standingBook));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param standingBook ${table.comment}
   * @return XfR
   */
  @PatchMapping("/standingbooks/{id}")
  public XfR patchUpdate(@RequestBody StandingBook standingBook,@PathVariable Long id) {
      StandingBook upstandingBook = standingBookServiceImpl.getById(id);
      if(upstandingBook != null){
        upstandingBook = ObjectCopyUtils.copyProperties(standingBook,upstandingBook,true);
      }
      return XfR.ok(standingBookServiceImpl.updateById(upstandingBook));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/standingbooks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(standingBookServiceImpl.removeById(id));
  }

  @PostMapping("/standingbooks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "standing_book");
     params.put("request", condition);

     return XfR.ok(standingBookServiceImpl.querys(params));
  }

}
