package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialAssetsBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialAssetsBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 资产的领用及更换申请单明细前端控制器
 *
 * @author ultraman
 * @date 2023-06-12
 */
@RestController
public class FinancialAssetsBillDetailController {

  @Autowired
  private IFinancialAssetsBillDetailService financialAssetsBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialAssetsBillDetail 资产的领用及更换申请单明细
   * @return
   */
  @GetMapping("/financialassetsbilldetails" )
  public XfR getFinancialAssetsBillDetails(XfPage page, FinancialAssetsBillDetail financialAssetsBillDetail) {
    return XfR.ok(financialAssetsBillDetailServiceImpl.page(page, Wrappers.query(financialAssetsBillDetail)));
  }

  /**
   * 通过id查询资产的领用及更换申请单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialassetsbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialAssetsBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增资产的领用及更换申请单明细
   * @param financialAssetsBillDetail 资产的领用及更换申请单明细
   * @return XfR
   */
  @PostMapping("/financialassetsbilldetails")
  public XfR save(@RequestBody FinancialAssetsBillDetail financialAssetsBillDetail) {
     return XfR.ok(financialAssetsBillDetailServiceImpl.save(financialAssetsBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据资产的领用及更换申请单明细
   * @param financialAssetsBillDetail 资产的领用及更换申请单明细
   * @return XfR
   */
  @PutMapping("/financialassetsbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialAssetsBillDetail financialAssetsBillDetail,@PathVariable Long id) {
      financialAssetsBillDetail.setId(id);
      return XfR.ok(financialAssetsBillDetailServiceImpl.updateById(financialAssetsBillDetail));
  }

  /**
   * 修改-传入修改的数据资产的领用及更换申请单明细
   * @param financialAssetsBillDetail 资产的领用及更换申请单明细
   * @return XfR
   */
  @PatchMapping("/financialassetsbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialAssetsBillDetail financialAssetsBillDetail,@PathVariable Long id) {
      FinancialAssetsBillDetail upfinancialAssetsBillDetail = financialAssetsBillDetailServiceImpl.getById(id);
      if(upfinancialAssetsBillDetail != null){
        upfinancialAssetsBillDetail = ObjectCopyUtils.copyProperties(financialAssetsBillDetail,upfinancialAssetsBillDetail,true);
      }
      return XfR.ok(financialAssetsBillDetailServiceImpl.updateById(upfinancialAssetsBillDetail));
  }

  /**
   * 通过id删除资产的领用及更换申请单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialassetsbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialAssetsBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialassetsbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_assets_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialAssetsBillDetailServiceImpl.querys(params));
  }

}
