package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialBusinessServeApplyBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialBusinessServeApplyBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-12
 */
@RestController
public class FinancialBusinessServeApplyBillController {

  @Autowired
  private IFinancialBusinessServeApplyBillService financialBusinessServeApplyBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialBusinessServeApplyBill ${table.comment}
   * @return
   */
  @GetMapping("/financialbusinessserveapplybills" )
  public XfR getFinancialBusinessServeApplyBills(XfPage page, FinancialBusinessServeApplyBill financialBusinessServeApplyBill) {
    return XfR.ok(financialBusinessServeApplyBillServiceImpl.page(page, Wrappers.query(financialBusinessServeApplyBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialbusinessserveapplybills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialBusinessServeApplyBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialBusinessServeApplyBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialbusinessserveapplybills")
  public XfR save(@RequestBody FinancialBusinessServeApplyBill financialBusinessServeApplyBill) {
     return XfR.ok(financialBusinessServeApplyBillServiceImpl.save(financialBusinessServeApplyBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialBusinessServeApplyBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialbusinessserveapplybills/{id}")
  public XfR putUpdate(@RequestBody FinancialBusinessServeApplyBill financialBusinessServeApplyBill,@PathVariable Long id) {
      financialBusinessServeApplyBill.setId(id);
      return XfR.ok(financialBusinessServeApplyBillServiceImpl.updateById(financialBusinessServeApplyBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialBusinessServeApplyBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialbusinessserveapplybills/{id}")
  public XfR patchUpdate(@RequestBody FinancialBusinessServeApplyBill financialBusinessServeApplyBill,@PathVariable Long id) {
      FinancialBusinessServeApplyBill upfinancialBusinessServeApplyBill = financialBusinessServeApplyBillServiceImpl.getById(id);
      if(upfinancialBusinessServeApplyBill != null){
        upfinancialBusinessServeApplyBill = ObjectCopyUtils.copyProperties(financialBusinessServeApplyBill,upfinancialBusinessServeApplyBill,true);
      }
      return XfR.ok(financialBusinessServeApplyBillServiceImpl.updateById(upfinancialBusinessServeApplyBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialbusinessserveapplybills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialBusinessServeApplyBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialbusinessserveapplybills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_business_serve_apply_bill");
     params.put("request", condition);

     return XfR.ok(financialBusinessServeApplyBillServiceImpl.querys(params));
  }

}
