package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialRfOtherDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialRfOtherDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 退款申请单「其他」明细前端控制器
 *
 * @author ultraman
 * @date 2023-06-12
 */
@RestController
public class FinancialRfOtherDetailController {

  @Autowired
  private IFinancialRfOtherDetailService financialRfOtherDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialRfOtherDetail 退款申请单「其他」明细
   * @return
   */
  @GetMapping("/financialrfotherdetails" )
  public XfR getFinancialRfOtherDetails(XfPage page, FinancialRfOtherDetail financialRfOtherDetail) {
    return XfR.ok(financialRfOtherDetailServiceImpl.page(page, Wrappers.query(financialRfOtherDetail)));
  }

  /**
   * 通过id查询退款申请单「其他」明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialrfotherdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialRfOtherDetailServiceImpl.getById(id));
  }

  /**
   * 新增退款申请单「其他」明细
   * @param financialRfOtherDetail 退款申请单「其他」明细
   * @return XfR
   */
  @PostMapping("/financialrfotherdetails")
  public XfR save(@RequestBody FinancialRfOtherDetail financialRfOtherDetail) {
     return XfR.ok(financialRfOtherDetailServiceImpl.save(financialRfOtherDetail));
  }

  /**
   * 修改-传入修改后的全部数据退款申请单「其他」明细
   * @param financialRfOtherDetail 退款申请单「其他」明细
   * @return XfR
   */
  @PutMapping("/financialrfotherdetails/{id}")
  public XfR putUpdate(@RequestBody FinancialRfOtherDetail financialRfOtherDetail,@PathVariable Long id) {
      financialRfOtherDetail.setId(id);
      return XfR.ok(financialRfOtherDetailServiceImpl.updateById(financialRfOtherDetail));
  }

  /**
   * 修改-传入修改的数据退款申请单「其他」明细
   * @param financialRfOtherDetail 退款申请单「其他」明细
   * @return XfR
   */
  @PatchMapping("/financialrfotherdetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialRfOtherDetail financialRfOtherDetail,@PathVariable Long id) {
      FinancialRfOtherDetail upfinancialRfOtherDetail = financialRfOtherDetailServiceImpl.getById(id);
      if(upfinancialRfOtherDetail != null){
        upfinancialRfOtherDetail = ObjectCopyUtils.copyProperties(financialRfOtherDetail,upfinancialRfOtherDetail,true);
      }
      return XfR.ok(financialRfOtherDetailServiceImpl.updateById(upfinancialRfOtherDetail));
  }

  /**
   * 通过id删除退款申请单「其他」明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialrfotherdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialRfOtherDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialrfotherdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_rf_other_detail");
     params.put("request", condition);

     return XfR.ok(financialRfOtherDetailServiceImpl.querys(params));
  }

}
