package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialSalaryBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialSalaryBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-12
 */
@RestController
public class FinancialSalaryBillController {

  @Autowired
  private IFinancialSalaryBillService financialSalaryBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialSalaryBill ${table.comment}
   * @return
   */
  @GetMapping("/financialsalarybills" )
  public XfR getFinancialSalaryBills(XfPage page, FinancialSalaryBill financialSalaryBill) {
    return XfR.ok(financialSalaryBillServiceImpl.page(page, Wrappers.query(financialSalaryBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialsalarybills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialSalaryBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialSalaryBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialsalarybills")
  public XfR save(@RequestBody FinancialSalaryBill financialSalaryBill) {
     return XfR.ok(financialSalaryBillServiceImpl.save(financialSalaryBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialSalaryBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialsalarybills/{id}")
  public XfR putUpdate(@RequestBody FinancialSalaryBill financialSalaryBill,@PathVariable Long id) {
      financialSalaryBill.setId(id);
      return XfR.ok(financialSalaryBillServiceImpl.updateById(financialSalaryBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialSalaryBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialsalarybills/{id}")
  public XfR patchUpdate(@RequestBody FinancialSalaryBill financialSalaryBill,@PathVariable Long id) {
      FinancialSalaryBill upfinancialSalaryBill = financialSalaryBillServiceImpl.getById(id);
      if(upfinancialSalaryBill != null){
        upfinancialSalaryBill = ObjectCopyUtils.copyProperties(financialSalaryBill,upfinancialSalaryBill,true);
      }
      return XfR.ok(financialSalaryBillServiceImpl.updateById(upfinancialSalaryBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialsalarybills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialSalaryBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialsalarybills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_salary_bill");
     params.put("request", condition);

     return XfR.ok(financialSalaryBillServiceImpl.querys(params));
  }

}
