package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.SmallBusinessIncome;
import com.xforceplus.ultraman.app.financialsettlement.service.ISmallBusinessIncomeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-12
 */
@RestController
public class SmallBusinessIncomeController {

  @Autowired
  private ISmallBusinessIncomeService smallBusinessIncomeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param smallBusinessIncome ${table.comment}
   * @return
   */
  @GetMapping("/smallbusinessincomes" )
  public XfR getSmallBusinessIncomes(XfPage page, SmallBusinessIncome smallBusinessIncome) {
    return XfR.ok(smallBusinessIncomeServiceImpl.page(page, Wrappers.query(smallBusinessIncome)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/smallbusinessincomes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(smallBusinessIncomeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param smallBusinessIncome ${table.comment}
   * @return XfR
   */
  @PostMapping("/smallbusinessincomes")
  public XfR save(@RequestBody SmallBusinessIncome smallBusinessIncome) {
     return XfR.ok(smallBusinessIncomeServiceImpl.save(smallBusinessIncome));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param smallBusinessIncome ${table.comment}
   * @return XfR
   */
  @PutMapping("/smallbusinessincomes/{id}")
  public XfR putUpdate(@RequestBody SmallBusinessIncome smallBusinessIncome,@PathVariable Long id) {
      smallBusinessIncome.setId(id);
      return XfR.ok(smallBusinessIncomeServiceImpl.updateById(smallBusinessIncome));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param smallBusinessIncome ${table.comment}
   * @return XfR
   */
  @PatchMapping("/smallbusinessincomes/{id}")
  public XfR patchUpdate(@RequestBody SmallBusinessIncome smallBusinessIncome,@PathVariable Long id) {
      SmallBusinessIncome upsmallBusinessIncome = smallBusinessIncomeServiceImpl.getById(id);
      if(upsmallBusinessIncome != null){
        upsmallBusinessIncome = ObjectCopyUtils.copyProperties(smallBusinessIncome,upsmallBusinessIncome,true);
      }
      return XfR.ok(smallBusinessIncomeServiceImpl.updateById(upsmallBusinessIncome));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/smallbusinessincomes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(smallBusinessIncomeServiceImpl.removeById(id));
  }

  @PostMapping("/smallbusinessincomes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "small_business_income");
     params.put("request", condition);

     return XfR.ok(smallBusinessIncomeServiceImpl.querys(params));
  }

}
