package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialPersonLoanBackBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialPersonLoanBackBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 个人借款归还单明细前端控制器
 *
 * @author ultraman
 * @date 2022-06-27
 */
@RestController
public class FinancialPersonLoanBackBillDetailController {

  @Autowired
  private IFinancialPersonLoanBackBillDetailService financialPersonLoanBackBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPersonLoanBackBillDetail 个人借款归还单明细
   * @return
   */
  @GetMapping("/financialpersonloanbackbilldetails" )
  public XfR getFinancialPersonLoanBackBillDetails(XfPage page, FinancialPersonLoanBackBillDetail financialPersonLoanBackBillDetail) {
    return XfR.ok(financialPersonLoanBackBillDetailServiceImpl.page(page, Wrappers.query(financialPersonLoanBackBillDetail)));
  }

  /**
   * 通过id查询个人借款归还单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpersonloanbackbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPersonLoanBackBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增个人借款归还单明细
   * @param financialPersonLoanBackBillDetail 个人借款归还单明细
   * @return XfR
   */
  @PostMapping("/financialpersonloanbackbilldetails")
  public XfR save(@RequestBody FinancialPersonLoanBackBillDetail financialPersonLoanBackBillDetail) {
     return XfR.ok(financialPersonLoanBackBillDetailServiceImpl.save(financialPersonLoanBackBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据个人借款归还单明细
   * @param financialPersonLoanBackBillDetail 个人借款归还单明细
   * @return XfR
   */
  @PutMapping("/financialpersonloanbackbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialPersonLoanBackBillDetail financialPersonLoanBackBillDetail,@PathVariable Long id) {
      financialPersonLoanBackBillDetail.setId(id);
      return XfR.ok(financialPersonLoanBackBillDetailServiceImpl.updateById(financialPersonLoanBackBillDetail));
  }

  /**
   * 修改-传入修改的数据个人借款归还单明细
   * @param financialPersonLoanBackBillDetail 个人借款归还单明细
   * @return XfR
   */
  @PatchMapping("/financialpersonloanbackbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialPersonLoanBackBillDetail financialPersonLoanBackBillDetail,@PathVariable Long id) {
      FinancialPersonLoanBackBillDetail upfinancialPersonLoanBackBillDetail = financialPersonLoanBackBillDetailServiceImpl.getById(id);
      if(upfinancialPersonLoanBackBillDetail != null){
        upfinancialPersonLoanBackBillDetail = ObjectCopyUtils.copyProperties(financialPersonLoanBackBillDetail,upfinancialPersonLoanBackBillDetail,true);
      }
      return XfR.ok(financialPersonLoanBackBillDetailServiceImpl.updateById(upfinancialPersonLoanBackBillDetail));
  }

  /**
   * 通过id删除个人借款归还单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpersonloanbackbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPersonLoanBackBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialpersonloanbackbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_person_loan_back_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialPersonLoanBackBillDetailServiceImpl.querys(params));
  }

}
