package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ServiceCostDetails;
import com.xforceplus.ultraman.app.financialsettlement.service.IServiceCostDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 服务成本明细前端控制器
 *
 * @author ultraman
 * @date 2022-06-27
 */
@RestController
public class ServiceCostDetailsController {

  @Autowired
  private IServiceCostDetailsService serviceCostDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param serviceCostDetails 服务成本明细
   * @return
   */
  @GetMapping("/servicecostdetailss" )
  public XfR getServiceCostDetailss(XfPage page, ServiceCostDetails serviceCostDetails) {
    return XfR.ok(serviceCostDetailsServiceImpl.page(page, Wrappers.query(serviceCostDetails)));
  }

  /**
   * 通过id查询服务成本明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/servicecostdetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(serviceCostDetailsServiceImpl.getById(id));
  }

  /**
   * 新增服务成本明细
   * @param serviceCostDetails 服务成本明细
   * @return XfR
   */
  @PostMapping("/servicecostdetailss")
  public XfR save(@RequestBody ServiceCostDetails serviceCostDetails) {
     return XfR.ok(serviceCostDetailsServiceImpl.save(serviceCostDetails));
  }

  /**
   * 修改-传入修改后的全部数据服务成本明细
   * @param serviceCostDetails 服务成本明细
   * @return XfR
   */
  @PutMapping("/servicecostdetailss/{id}")
  public XfR putUpdate(@RequestBody ServiceCostDetails serviceCostDetails,@PathVariable Long id) {
      serviceCostDetails.setId(id);
      return XfR.ok(serviceCostDetailsServiceImpl.updateById(serviceCostDetails));
  }

  /**
   * 修改-传入修改的数据服务成本明细
   * @param serviceCostDetails 服务成本明细
   * @return XfR
   */
  @PatchMapping("/servicecostdetailss/{id}")
  public XfR patchUpdate(@RequestBody ServiceCostDetails serviceCostDetails,@PathVariable Long id) {
      ServiceCostDetails upserviceCostDetails = serviceCostDetailsServiceImpl.getById(id);
      if(upserviceCostDetails != null){
        upserviceCostDetails = ObjectCopyUtils.copyProperties(serviceCostDetails,upserviceCostDetails,true);
      }
      return XfR.ok(serviceCostDetailsServiceImpl.updateById(upserviceCostDetails));
  }

  /**
   * 通过id删除服务成本明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/servicecostdetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(serviceCostDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/servicecostdetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "service_cost_details");
     params.put("request", condition);

     return XfR.ok(serviceCostDetailsServiceImpl.querys(params));
  }

}
