package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialAssetsTransferBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialAssetsTransferBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 资产调拨转移申请单前端控制器
 *
 * @author ultraman
 * @date 2022-06-27
 */
@RestController
public class FinancialAssetsTransferBillController {

  @Autowired
  private IFinancialAssetsTransferBillService financialAssetsTransferBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialAssetsTransferBill 资产调拨转移申请单
   * @return
   */
  @GetMapping("/financialassetstransferbills" )
  public XfR getFinancialAssetsTransferBills(XfPage page, FinancialAssetsTransferBill financialAssetsTransferBill) {
    return XfR.ok(financialAssetsTransferBillServiceImpl.page(page, Wrappers.query(financialAssetsTransferBill)));
  }

  /**
   * 通过id查询资产调拨转移申请单
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialassetstransferbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialAssetsTransferBillServiceImpl.getById(id));
  }

  /**
   * 新增资产调拨转移申请单
   * @param financialAssetsTransferBill 资产调拨转移申请单
   * @return XfR
   */
  @PostMapping("/financialassetstransferbills")
  public XfR save(@RequestBody FinancialAssetsTransferBill financialAssetsTransferBill) {
     return XfR.ok(financialAssetsTransferBillServiceImpl.save(financialAssetsTransferBill));
  }

  /**
   * 修改-传入修改后的全部数据资产调拨转移申请单
   * @param financialAssetsTransferBill 资产调拨转移申请单
   * @return XfR
   */
  @PutMapping("/financialassetstransferbills/{id}")
  public XfR putUpdate(@RequestBody FinancialAssetsTransferBill financialAssetsTransferBill,@PathVariable Long id) {
      financialAssetsTransferBill.setId(id);
      return XfR.ok(financialAssetsTransferBillServiceImpl.updateById(financialAssetsTransferBill));
  }

  /**
   * 修改-传入修改的数据资产调拨转移申请单
   * @param financialAssetsTransferBill 资产调拨转移申请单
   * @return XfR
   */
  @PatchMapping("/financialassetstransferbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialAssetsTransferBill financialAssetsTransferBill,@PathVariable Long id) {
      FinancialAssetsTransferBill upfinancialAssetsTransferBill = financialAssetsTransferBillServiceImpl.getById(id);
      if(upfinancialAssetsTransferBill != null){
        upfinancialAssetsTransferBill = ObjectCopyUtils.copyProperties(financialAssetsTransferBill,upfinancialAssetsTransferBill,true);
      }
      return XfR.ok(financialAssetsTransferBillServiceImpl.updateById(upfinancialAssetsTransferBill));
  }

  /**
   * 通过id删除资产调拨转移申请单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialassetstransferbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialAssetsTransferBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialassetstransferbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_assets_transfer_bill");
     params.put("request", condition);

     return XfR.ok(financialAssetsTransferBillServiceImpl.querys(params));
  }

}
