package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialTransferBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialTransferBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-27
 */
@RestController
public class FinancialTransferBillController {

  @Autowired
  private IFinancialTransferBillService financialTransferBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialTransferBill ${table.comment}
   * @return
   */
  @GetMapping("/financialtransferbills" )
  public XfR getFinancialTransferBills(XfPage page, FinancialTransferBill financialTransferBill) {
    return XfR.ok(financialTransferBillServiceImpl.page(page, Wrappers.query(financialTransferBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialtransferbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialTransferBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialTransferBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialtransferbills")
  public XfR save(@RequestBody FinancialTransferBill financialTransferBill) {
     return XfR.ok(financialTransferBillServiceImpl.save(financialTransferBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialTransferBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialtransferbills/{id}")
  public XfR putUpdate(@RequestBody FinancialTransferBill financialTransferBill,@PathVariable Long id) {
      financialTransferBill.setId(id);
      return XfR.ok(financialTransferBillServiceImpl.updateById(financialTransferBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialTransferBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialtransferbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialTransferBill financialTransferBill,@PathVariable Long id) {
      FinancialTransferBill upfinancialTransferBill = financialTransferBillServiceImpl.getById(id);
      if(upfinancialTransferBill != null){
        upfinancialTransferBill = ObjectCopyUtils.copyProperties(financialTransferBill,upfinancialTransferBill,true);
      }
      return XfR.ok(financialTransferBillServiceImpl.updateById(upfinancialTransferBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialtransferbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialTransferBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialtransferbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_transfer_bill");
     params.put("request", condition);

     return XfR.ok(financialTransferBillServiceImpl.querys(params));
  }

}
