package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ContractTaxNoDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IContractTaxNoDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-09-25
 */
@RestController
public class ContractTaxNoDetailController {

  @Autowired
  private IContractTaxNoDetailService contractTaxNoDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param contractTaxNoDetail ${table.comment}
   * @return
   */
  @GetMapping("/contracttaxnodetails" )
  public XfR getContractTaxNoDetails(XfPage page, ContractTaxNoDetail contractTaxNoDetail) {
    return XfR.ok(contractTaxNoDetailServiceImpl.page(page, Wrappers.query(contractTaxNoDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/contracttaxnodetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(contractTaxNoDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param contractTaxNoDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/contracttaxnodetails")
  public XfR save(@RequestBody ContractTaxNoDetail contractTaxNoDetail) {
     return XfR.ok(contractTaxNoDetailServiceImpl.save(contractTaxNoDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param contractTaxNoDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/contracttaxnodetails/{id}")
  public XfR putUpdate(@RequestBody ContractTaxNoDetail contractTaxNoDetail,@PathVariable Long id) {
      contractTaxNoDetail.setId(id);
      return XfR.ok(contractTaxNoDetailServiceImpl.updateById(contractTaxNoDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param contractTaxNoDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/contracttaxnodetails/{id}")
  public XfR patchUpdate(@RequestBody ContractTaxNoDetail contractTaxNoDetail,@PathVariable Long id) {
      ContractTaxNoDetail upcontractTaxNoDetail = contractTaxNoDetailServiceImpl.getById(id);
      if(upcontractTaxNoDetail != null){
        upcontractTaxNoDetail = ObjectCopyUtils.copyProperties(contractTaxNoDetail,upcontractTaxNoDetail,true);
      }
      return XfR.ok(contractTaxNoDetailServiceImpl.updateById(upcontractTaxNoDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/contracttaxnodetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(contractTaxNoDetailServiceImpl.removeById(id));
  }

  @PostMapping("/contracttaxnodetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "contract_tax_no_detail");
     params.put("request", condition);

     return XfR.ok(contractTaxNoDetailServiceImpl.querys(params));
  }

}
