package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FkjBIllExtRelation;
import com.xforceplus.ultraman.app.financialsettlement.service.IFkjBIllExtRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-09-25
 */
@RestController
public class FkjBIllExtRelationController {

  @Autowired
  private IFkjBIllExtRelationService fkjBIllExtRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fkjBIllExtRelation ${table.comment}
   * @return
   */
  @GetMapping("/fkjbillextrelations" )
  public XfR getFkjBIllExtRelations(XfPage page, FkjBIllExtRelation fkjBIllExtRelation) {
    return XfR.ok(fkjBIllExtRelationServiceImpl.page(page, Wrappers.query(fkjBIllExtRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/fkjbillextrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fkjBIllExtRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param fkjBIllExtRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/fkjbillextrelations")
  public XfR save(@RequestBody FkjBIllExtRelation fkjBIllExtRelation) {
     return XfR.ok(fkjBIllExtRelationServiceImpl.save(fkjBIllExtRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param fkjBIllExtRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/fkjbillextrelations/{id}")
  public XfR putUpdate(@RequestBody FkjBIllExtRelation fkjBIllExtRelation,@PathVariable Long id) {
      fkjBIllExtRelation.setId(id);
      return XfR.ok(fkjBIllExtRelationServiceImpl.updateById(fkjBIllExtRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param fkjBIllExtRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/fkjbillextrelations/{id}")
  public XfR patchUpdate(@RequestBody FkjBIllExtRelation fkjBIllExtRelation,@PathVariable Long id) {
      FkjBIllExtRelation upfkjBIllExtRelation = fkjBIllExtRelationServiceImpl.getById(id);
      if(upfkjBIllExtRelation != null){
        upfkjBIllExtRelation = ObjectCopyUtils.copyProperties(fkjBIllExtRelation,upfkjBIllExtRelation,true);
      }
      return XfR.ok(fkjBIllExtRelationServiceImpl.updateById(upfkjBIllExtRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fkjbillextrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fkjBIllExtRelationServiceImpl.removeById(id));
  }

  @PostMapping("/fkjbillextrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fkj_b_ill_ext_relation");
     params.put("request", condition);

     return XfR.ok(fkjBIllExtRelationServiceImpl.querys(params));
  }

}
