package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FkjInvoiceBillImageRelation;
import com.xforceplus.ultraman.app.financialsettlement.service.IFkjInvoiceBillImageRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-09-25
 */
@RestController
public class FkjInvoiceBillImageRelationController {

  @Autowired
  private IFkjInvoiceBillImageRelationService fkjInvoiceBillImageRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fkjInvoiceBillImageRelation ${table.comment}
   * @return
   */
  @GetMapping("/fkjinvoicebillimagerelations" )
  public XfR getFkjInvoiceBillImageRelations(XfPage page, FkjInvoiceBillImageRelation fkjInvoiceBillImageRelation) {
    return XfR.ok(fkjInvoiceBillImageRelationServiceImpl.page(page, Wrappers.query(fkjInvoiceBillImageRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/fkjinvoicebillimagerelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fkjInvoiceBillImageRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param fkjInvoiceBillImageRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/fkjinvoicebillimagerelations")
  public XfR save(@RequestBody FkjInvoiceBillImageRelation fkjInvoiceBillImageRelation) {
     return XfR.ok(fkjInvoiceBillImageRelationServiceImpl.save(fkjInvoiceBillImageRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param fkjInvoiceBillImageRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/fkjinvoicebillimagerelations/{id}")
  public XfR putUpdate(@RequestBody FkjInvoiceBillImageRelation fkjInvoiceBillImageRelation,@PathVariable Long id) {
      fkjInvoiceBillImageRelation.setId(id);
      return XfR.ok(fkjInvoiceBillImageRelationServiceImpl.updateById(fkjInvoiceBillImageRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param fkjInvoiceBillImageRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/fkjinvoicebillimagerelations/{id}")
  public XfR patchUpdate(@RequestBody FkjInvoiceBillImageRelation fkjInvoiceBillImageRelation,@PathVariable Long id) {
      FkjInvoiceBillImageRelation upfkjInvoiceBillImageRelation = fkjInvoiceBillImageRelationServiceImpl.getById(id);
      if(upfkjInvoiceBillImageRelation != null){
        upfkjInvoiceBillImageRelation = ObjectCopyUtils.copyProperties(fkjInvoiceBillImageRelation,upfkjInvoiceBillImageRelation,true);
      }
      return XfR.ok(fkjInvoiceBillImageRelationServiceImpl.updateById(upfkjInvoiceBillImageRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fkjinvoicebillimagerelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fkjInvoiceBillImageRelationServiceImpl.removeById(id));
  }

  @PostMapping("/fkjinvoicebillimagerelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fkj_invoice_bill_image_relation");
     params.put("request", condition);

     return XfR.ok(fkjInvoiceBillImageRelationServiceImpl.querys(params));
  }

}
