package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.StandingBookAttachment;
import com.xforceplus.ultraman.app.financialsettlement.service.IStandingBookAttachmentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-10-27
 */
@RestController
public class StandingBookAttachmentController {

  @Autowired
  private IStandingBookAttachmentService standingBookAttachmentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param standingBookAttachment ${table.comment}
   * @return
   */
  @GetMapping("/standingbookattachments" )
  public XfR getStandingBookAttachments(XfPage page, StandingBookAttachment standingBookAttachment) {
    return XfR.ok(standingBookAttachmentServiceImpl.page(page, Wrappers.query(standingBookAttachment)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/standingbookattachments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(standingBookAttachmentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param standingBookAttachment ${table.comment}
   * @return XfR
   */
  @PostMapping("/standingbookattachments")
  public XfR save(@RequestBody StandingBookAttachment standingBookAttachment) {
     return XfR.ok(standingBookAttachmentServiceImpl.save(standingBookAttachment));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param standingBookAttachment ${table.comment}
   * @return XfR
   */
  @PutMapping("/standingbookattachments/{id}")
  public XfR putUpdate(@RequestBody StandingBookAttachment standingBookAttachment,@PathVariable Long id) {
      standingBookAttachment.setId(id);
      return XfR.ok(standingBookAttachmentServiceImpl.updateById(standingBookAttachment));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param standingBookAttachment ${table.comment}
   * @return XfR
   */
  @PatchMapping("/standingbookattachments/{id}")
  public XfR patchUpdate(@RequestBody StandingBookAttachment standingBookAttachment,@PathVariable Long id) {
      StandingBookAttachment upstandingBookAttachment = standingBookAttachmentServiceImpl.getById(id);
      if(upstandingBookAttachment != null){
        upstandingBookAttachment = ObjectCopyUtils.copyProperties(standingBookAttachment,upstandingBookAttachment,true);
      }
      return XfR.ok(standingBookAttachmentServiceImpl.updateById(upstandingBookAttachment));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/standingbookattachments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(standingBookAttachmentServiceImpl.removeById(id));
  }

  @PostMapping("/standingbookattachments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "standing_book_attachment");
     params.put("request", condition);

     return XfR.ok(standingBookAttachmentServiceImpl.querys(params));
  }

}
