package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.DepartmentBudgetImportData;
import com.xforceplus.ultraman.app.financialsettlement.service.IDepartmentBudgetImportDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-21
 */
@RestController
public class DepartmentBudgetImportDataController {

  @Autowired
  private IDepartmentBudgetImportDataService departmentBudgetImportDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param departmentBudgetImportData ${table.comment}
   * @return
   */
  @GetMapping("/departmentbudgetimportdatas" )
  public XfR getDepartmentBudgetImportDatas(XfPage page, DepartmentBudgetImportData departmentBudgetImportData) {
    return XfR.ok(departmentBudgetImportDataServiceImpl.page(page, Wrappers.query(departmentBudgetImportData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/departmentbudgetimportdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(departmentBudgetImportDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param departmentBudgetImportData ${table.comment}
   * @return XfR
   */
  @PostMapping("/departmentbudgetimportdatas")
  public XfR save(@RequestBody DepartmentBudgetImportData departmentBudgetImportData) {
     return XfR.ok(departmentBudgetImportDataServiceImpl.save(departmentBudgetImportData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param departmentBudgetImportData ${table.comment}
   * @return XfR
   */
  @PutMapping("/departmentbudgetimportdatas/{id}")
  public XfR putUpdate(@RequestBody DepartmentBudgetImportData departmentBudgetImportData,@PathVariable Long id) {
      departmentBudgetImportData.setId(id);
      return XfR.ok(departmentBudgetImportDataServiceImpl.updateById(departmentBudgetImportData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param departmentBudgetImportData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/departmentbudgetimportdatas/{id}")
  public XfR patchUpdate(@RequestBody DepartmentBudgetImportData departmentBudgetImportData,@PathVariable Long id) {
      DepartmentBudgetImportData updepartmentBudgetImportData = departmentBudgetImportDataServiceImpl.getById(id);
      if(updepartmentBudgetImportData != null){
        updepartmentBudgetImportData = ObjectCopyUtils.copyProperties(departmentBudgetImportData,updepartmentBudgetImportData,true);
      }
      return XfR.ok(departmentBudgetImportDataServiceImpl.updateById(updepartmentBudgetImportData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/departmentbudgetimportdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(departmentBudgetImportDataServiceImpl.removeById(id));
  }

  @PostMapping("/departmentbudgetimportdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "department_budget_import_data");
     params.put("request", condition);

     return XfR.ok(departmentBudgetImportDataServiceImpl.querys(params));
  }

}
