package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.DepartmentBudgetItem;
import com.xforceplus.ultraman.app.financialsettlement.service.IDepartmentBudgetItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-21
 */
@RestController
public class DepartmentBudgetItemController {

  @Autowired
  private IDepartmentBudgetItemService departmentBudgetItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param departmentBudgetItem ${table.comment}
   * @return
   */
  @GetMapping("/departmentbudgetitems" )
  public XfR getDepartmentBudgetItems(XfPage page, DepartmentBudgetItem departmentBudgetItem) {
    return XfR.ok(departmentBudgetItemServiceImpl.page(page, Wrappers.query(departmentBudgetItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/departmentbudgetitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(departmentBudgetItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param departmentBudgetItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/departmentbudgetitems")
  public XfR save(@RequestBody DepartmentBudgetItem departmentBudgetItem) {
     return XfR.ok(departmentBudgetItemServiceImpl.save(departmentBudgetItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param departmentBudgetItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/departmentbudgetitems/{id}")
  public XfR putUpdate(@RequestBody DepartmentBudgetItem departmentBudgetItem,@PathVariable Long id) {
      departmentBudgetItem.setId(id);
      return XfR.ok(departmentBudgetItemServiceImpl.updateById(departmentBudgetItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param departmentBudgetItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/departmentbudgetitems/{id}")
  public XfR patchUpdate(@RequestBody DepartmentBudgetItem departmentBudgetItem,@PathVariable Long id) {
      DepartmentBudgetItem updepartmentBudgetItem = departmentBudgetItemServiceImpl.getById(id);
      if(updepartmentBudgetItem != null){
        updepartmentBudgetItem = ObjectCopyUtils.copyProperties(departmentBudgetItem,updepartmentBudgetItem,true);
      }
      return XfR.ok(departmentBudgetItemServiceImpl.updateById(updepartmentBudgetItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/departmentbudgetitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(departmentBudgetItemServiceImpl.removeById(id));
  }

  @PostMapping("/departmentbudgetitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "department_budget_item");
     params.put("request", condition);

     return XfR.ok(departmentBudgetItemServiceImpl.querys(params));
  }

}
