package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialInventorySaleDeliveryBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialInventorySaleDeliveryBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-21
 */
@RestController
public class FinancialInventorySaleDeliveryBillController {

  @Autowired
  private IFinancialInventorySaleDeliveryBillService financialInventorySaleDeliveryBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialInventorySaleDeliveryBill ${table.comment}
   * @return
   */
  @GetMapping("/financialinventorysaledeliverybills" )
  public XfR getFinancialInventorySaleDeliveryBills(XfPage page, FinancialInventorySaleDeliveryBill financialInventorySaleDeliveryBill) {
    return XfR.ok(financialInventorySaleDeliveryBillServiceImpl.page(page, Wrappers.query(financialInventorySaleDeliveryBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialinventorysaledeliverybills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialInventorySaleDeliveryBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialInventorySaleDeliveryBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialinventorysaledeliverybills")
  public XfR save(@RequestBody FinancialInventorySaleDeliveryBill financialInventorySaleDeliveryBill) {
     return XfR.ok(financialInventorySaleDeliveryBillServiceImpl.save(financialInventorySaleDeliveryBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialInventorySaleDeliveryBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialinventorysaledeliverybills/{id}")
  public XfR putUpdate(@RequestBody FinancialInventorySaleDeliveryBill financialInventorySaleDeliveryBill,@PathVariable Long id) {
      financialInventorySaleDeliveryBill.setId(id);
      return XfR.ok(financialInventorySaleDeliveryBillServiceImpl.updateById(financialInventorySaleDeliveryBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialInventorySaleDeliveryBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialinventorysaledeliverybills/{id}")
  public XfR patchUpdate(@RequestBody FinancialInventorySaleDeliveryBill financialInventorySaleDeliveryBill,@PathVariable Long id) {
      FinancialInventorySaleDeliveryBill upfinancialInventorySaleDeliveryBill = financialInventorySaleDeliveryBillServiceImpl.getById(id);
      if(upfinancialInventorySaleDeliveryBill != null){
        upfinancialInventorySaleDeliveryBill = ObjectCopyUtils.copyProperties(financialInventorySaleDeliveryBill,upfinancialInventorySaleDeliveryBill,true);
      }
      return XfR.ok(financialInventorySaleDeliveryBillServiceImpl.updateById(upfinancialInventorySaleDeliveryBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialinventorysaledeliverybills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialInventorySaleDeliveryBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialinventorysaledeliverybills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_inventory_sale_delivery_bill");
     params.put("request", condition);

     return XfR.ok(financialInventorySaleDeliveryBillServiceImpl.querys(params));
  }

}
