package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialSyncWindow;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialSyncWindowService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-21
 */
@RestController
public class FinancialSyncWindowController {

  @Autowired
  private IFinancialSyncWindowService financialSyncWindowServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialSyncWindow ${table.comment}
   * @return
   */
  @GetMapping("/financialsyncwindows" )
  public XfR getFinancialSyncWindows(XfPage page, FinancialSyncWindow financialSyncWindow) {
    return XfR.ok(financialSyncWindowServiceImpl.page(page, Wrappers.query(financialSyncWindow)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialsyncwindows/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialSyncWindowServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialSyncWindow ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialsyncwindows")
  public XfR save(@RequestBody FinancialSyncWindow financialSyncWindow) {
     return XfR.ok(financialSyncWindowServiceImpl.save(financialSyncWindow));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialSyncWindow ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialsyncwindows/{id}")
  public XfR putUpdate(@RequestBody FinancialSyncWindow financialSyncWindow,@PathVariable Long id) {
      financialSyncWindow.setId(id);
      return XfR.ok(financialSyncWindowServiceImpl.updateById(financialSyncWindow));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialSyncWindow ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialsyncwindows/{id}")
  public XfR patchUpdate(@RequestBody FinancialSyncWindow financialSyncWindow,@PathVariable Long id) {
      FinancialSyncWindow upfinancialSyncWindow = financialSyncWindowServiceImpl.getById(id);
      if(upfinancialSyncWindow != null){
        upfinancialSyncWindow = ObjectCopyUtils.copyProperties(financialSyncWindow,upfinancialSyncWindow,true);
      }
      return XfR.ok(financialSyncWindowServiceImpl.updateById(upfinancialSyncWindow));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialsyncwindows/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialSyncWindowServiceImpl.removeById(id));
  }

  @PostMapping("/financialsyncwindows/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_sync_window");
     params.put("request", condition);

     return XfR.ok(financialSyncWindowServiceImpl.querys(params));
  }

}
