package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.SmallOrderInfo;
import com.xforceplus.ultraman.app.financialsettlement.service.ISmallOrderInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-21
 */
@RestController
public class SmallOrderInfoController {

  @Autowired
  private ISmallOrderInfoService smallOrderInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param smallOrderInfo ${table.comment}
   * @return
   */
  @GetMapping("/smallorderinfos" )
  public XfR getSmallOrderInfos(XfPage page, SmallOrderInfo smallOrderInfo) {
    return XfR.ok(smallOrderInfoServiceImpl.page(page, Wrappers.query(smallOrderInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/smallorderinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(smallOrderInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param smallOrderInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/smallorderinfos")
  public XfR save(@RequestBody SmallOrderInfo smallOrderInfo) {
     return XfR.ok(smallOrderInfoServiceImpl.save(smallOrderInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param smallOrderInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/smallorderinfos/{id}")
  public XfR putUpdate(@RequestBody SmallOrderInfo smallOrderInfo,@PathVariable Long id) {
      smallOrderInfo.setId(id);
      return XfR.ok(smallOrderInfoServiceImpl.updateById(smallOrderInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param smallOrderInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/smallorderinfos/{id}")
  public XfR patchUpdate(@RequestBody SmallOrderInfo smallOrderInfo,@PathVariable Long id) {
      SmallOrderInfo upsmallOrderInfo = smallOrderInfoServiceImpl.getById(id);
      if(upsmallOrderInfo != null){
        upsmallOrderInfo = ObjectCopyUtils.copyProperties(smallOrderInfo,upsmallOrderInfo,true);
      }
      return XfR.ok(smallOrderInfoServiceImpl.updateById(upsmallOrderInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/smallorderinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(smallOrderInfoServiceImpl.removeById(id));
  }

  @PostMapping("/smallorderinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "small_order_info");
     params.put("request", condition);

     return XfR.ok(smallOrderInfoServiceImpl.querys(params));
  }

}
