package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.BillInvoiceSyn;
import com.xforceplus.ultraman.app.financialsettlement.service.IBillInvoiceSynService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 单据发票同步信息-易快报前端控制器
 *
 * @author ultraman
 * @date 2023-12-06
 */
@RestController
public class BillInvoiceSynController {

  @Autowired
  private IBillInvoiceSynService billInvoiceSynServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billInvoiceSyn 单据发票同步信息-易快报
   * @return
   */
  @GetMapping("/billinvoicesyns" )
  public XfR getBillInvoiceSyns(XfPage page, BillInvoiceSyn billInvoiceSyn) {
    return XfR.ok(billInvoiceSynServiceImpl.page(page, Wrappers.query(billInvoiceSyn)));
  }

  /**
   * 通过id查询单据发票同步信息-易快报
   * @param  id
   * @return XfR
   */
  @GetMapping("/billinvoicesyns/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billInvoiceSynServiceImpl.getById(id));
  }

  /**
   * 新增单据发票同步信息-易快报
   * @param billInvoiceSyn 单据发票同步信息-易快报
   * @return XfR
   */
  @PostMapping("/billinvoicesyns")
  public XfR save(@RequestBody BillInvoiceSyn billInvoiceSyn) {
     return XfR.ok(billInvoiceSynServiceImpl.save(billInvoiceSyn));
  }

  /**
   * 修改-传入修改后的全部数据单据发票同步信息-易快报
   * @param billInvoiceSyn 单据发票同步信息-易快报
   * @return XfR
   */
  @PutMapping("/billinvoicesyns/{id}")
  public XfR putUpdate(@RequestBody BillInvoiceSyn billInvoiceSyn,@PathVariable Long id) {
      billInvoiceSyn.setId(id);
      return XfR.ok(billInvoiceSynServiceImpl.updateById(billInvoiceSyn));
  }

  /**
   * 修改-传入修改的数据单据发票同步信息-易快报
   * @param billInvoiceSyn 单据发票同步信息-易快报
   * @return XfR
   */
  @PatchMapping("/billinvoicesyns/{id}")
  public XfR patchUpdate(@RequestBody BillInvoiceSyn billInvoiceSyn,@PathVariable Long id) {
      BillInvoiceSyn upbillInvoiceSyn = billInvoiceSynServiceImpl.getById(id);
      if(upbillInvoiceSyn != null){
        upbillInvoiceSyn = ObjectCopyUtils.copyProperties(billInvoiceSyn,upbillInvoiceSyn,true);
      }
      return XfR.ok(billInvoiceSynServiceImpl.updateById(upbillInvoiceSyn));
  }

  /**
   * 通过id删除单据发票同步信息-易快报
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billinvoicesyns/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billInvoiceSynServiceImpl.removeById(id));
  }

  @PostMapping("/billinvoicesyns/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_invoice_syn");
     params.put("request", condition);

     return XfR.ok(billInvoiceSynServiceImpl.querys(params));
  }

}
