package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.BillStatics;
import com.xforceplus.ultraman.app.financialsettlement.service.IBillStaticsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-06
 */
@RestController
public class BillStaticsController {

  @Autowired
  private IBillStaticsService billStaticsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billStatics ${table.comment}
   * @return
   */
  @GetMapping("/billstaticss" )
  public XfR getBillStaticss(XfPage page, BillStatics billStatics) {
    return XfR.ok(billStaticsServiceImpl.page(page, Wrappers.query(billStatics)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billstaticss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billStaticsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billStatics ${table.comment}
   * @return XfR
   */
  @PostMapping("/billstaticss")
  public XfR save(@RequestBody BillStatics billStatics) {
     return XfR.ok(billStaticsServiceImpl.save(billStatics));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billStatics ${table.comment}
   * @return XfR
   */
  @PutMapping("/billstaticss/{id}")
  public XfR putUpdate(@RequestBody BillStatics billStatics,@PathVariable Long id) {
      billStatics.setId(id);
      return XfR.ok(billStaticsServiceImpl.updateById(billStatics));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billStatics ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billstaticss/{id}")
  public XfR patchUpdate(@RequestBody BillStatics billStatics,@PathVariable Long id) {
      BillStatics upbillStatics = billStaticsServiceImpl.getById(id);
      if(upbillStatics != null){
        upbillStatics = ObjectCopyUtils.copyProperties(billStatics,upbillStatics,true);
      }
      return XfR.ok(billStaticsServiceImpl.updateById(upbillStatics));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billstaticss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billStaticsServiceImpl.removeById(id));
  }

  @PostMapping("/billstaticss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_statics");
     params.put("request", condition);

     return XfR.ok(billStaticsServiceImpl.querys(params));
  }

}
