package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialInvoiceCheckBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialInvoiceCheckBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-06
 */
@RestController
public class FinancialInvoiceCheckBillController {

  @Autowired
  private IFinancialInvoiceCheckBillService financialInvoiceCheckBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialInvoiceCheckBill ${table.comment}
   * @return
   */
  @GetMapping("/financialinvoicecheckbills" )
  public XfR getFinancialInvoiceCheckBills(XfPage page, FinancialInvoiceCheckBill financialInvoiceCheckBill) {
    return XfR.ok(financialInvoiceCheckBillServiceImpl.page(page, Wrappers.query(financialInvoiceCheckBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialinvoicecheckbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialInvoiceCheckBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialInvoiceCheckBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialinvoicecheckbills")
  public XfR save(@RequestBody FinancialInvoiceCheckBill financialInvoiceCheckBill) {
     return XfR.ok(financialInvoiceCheckBillServiceImpl.save(financialInvoiceCheckBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialInvoiceCheckBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialinvoicecheckbills/{id}")
  public XfR putUpdate(@RequestBody FinancialInvoiceCheckBill financialInvoiceCheckBill,@PathVariable Long id) {
      financialInvoiceCheckBill.setId(id);
      return XfR.ok(financialInvoiceCheckBillServiceImpl.updateById(financialInvoiceCheckBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialInvoiceCheckBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialinvoicecheckbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialInvoiceCheckBill financialInvoiceCheckBill,@PathVariable Long id) {
      FinancialInvoiceCheckBill upfinancialInvoiceCheckBill = financialInvoiceCheckBillServiceImpl.getById(id);
      if(upfinancialInvoiceCheckBill != null){
        upfinancialInvoiceCheckBill = ObjectCopyUtils.copyProperties(financialInvoiceCheckBill,upfinancialInvoiceCheckBill,true);
      }
      return XfR.ok(financialInvoiceCheckBillServiceImpl.updateById(upfinancialInvoiceCheckBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialinvoicecheckbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialInvoiceCheckBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialinvoicecheckbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_invoice_check_bill");
     params.put("request", condition);

     return XfR.ok(financialInvoiceCheckBillServiceImpl.querys(params));
  }

}
