package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialTravelReimbursementBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialTravelReimbursementBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-06
 */
@RestController
public class FinancialTravelReimbursementBillController {

  @Autowired
  private IFinancialTravelReimbursementBillService financialTravelReimbursementBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialTravelReimbursementBill ${table.comment}
   * @return
   */
  @GetMapping("/financialtravelreimbursementbills" )
  public XfR getFinancialTravelReimbursementBills(XfPage page, FinancialTravelReimbursementBill financialTravelReimbursementBill) {
    return XfR.ok(financialTravelReimbursementBillServiceImpl.page(page, Wrappers.query(financialTravelReimbursementBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialtravelreimbursementbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialTravelReimbursementBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialTravelReimbursementBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialtravelreimbursementbills")
  public XfR save(@RequestBody FinancialTravelReimbursementBill financialTravelReimbursementBill) {
     return XfR.ok(financialTravelReimbursementBillServiceImpl.save(financialTravelReimbursementBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialTravelReimbursementBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialtravelreimbursementbills/{id}")
  public XfR putUpdate(@RequestBody FinancialTravelReimbursementBill financialTravelReimbursementBill,@PathVariable Long id) {
      financialTravelReimbursementBill.setId(id);
      return XfR.ok(financialTravelReimbursementBillServiceImpl.updateById(financialTravelReimbursementBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialTravelReimbursementBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialtravelreimbursementbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialTravelReimbursementBill financialTravelReimbursementBill,@PathVariable Long id) {
      FinancialTravelReimbursementBill upfinancialTravelReimbursementBill = financialTravelReimbursementBillServiceImpl.getById(id);
      if(upfinancialTravelReimbursementBill != null){
        upfinancialTravelReimbursementBill = ObjectCopyUtils.copyProperties(financialTravelReimbursementBill,upfinancialTravelReimbursementBill,true);
      }
      return XfR.ok(financialTravelReimbursementBillServiceImpl.updateById(upfinancialTravelReimbursementBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialtravelreimbursementbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialTravelReimbursementBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialtravelreimbursementbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_travel_reimbursement_bill");
     params.put("request", condition);

     return XfR.ok(financialTravelReimbursementBillServiceImpl.querys(params));
  }

}
