package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.SmallOrderInvoiceRelation;
import com.xforceplus.ultraman.app.financialsettlement.service.ISmallOrderInvoiceRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-06
 */
@RestController
public class SmallOrderInvoiceRelationController {

  @Autowired
  private ISmallOrderInvoiceRelationService smallOrderInvoiceRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param smallOrderInvoiceRelation ${table.comment}
   * @return
   */
  @GetMapping("/smallorderinvoicerelations" )
  public XfR getSmallOrderInvoiceRelations(XfPage page, SmallOrderInvoiceRelation smallOrderInvoiceRelation) {
    return XfR.ok(smallOrderInvoiceRelationServiceImpl.page(page, Wrappers.query(smallOrderInvoiceRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/smallorderinvoicerelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(smallOrderInvoiceRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param smallOrderInvoiceRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/smallorderinvoicerelations")
  public XfR save(@RequestBody SmallOrderInvoiceRelation smallOrderInvoiceRelation) {
     return XfR.ok(smallOrderInvoiceRelationServiceImpl.save(smallOrderInvoiceRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param smallOrderInvoiceRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/smallorderinvoicerelations/{id}")
  public XfR putUpdate(@RequestBody SmallOrderInvoiceRelation smallOrderInvoiceRelation,@PathVariable Long id) {
      smallOrderInvoiceRelation.setId(id);
      return XfR.ok(smallOrderInvoiceRelationServiceImpl.updateById(smallOrderInvoiceRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param smallOrderInvoiceRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/smallorderinvoicerelations/{id}")
  public XfR patchUpdate(@RequestBody SmallOrderInvoiceRelation smallOrderInvoiceRelation,@PathVariable Long id) {
      SmallOrderInvoiceRelation upsmallOrderInvoiceRelation = smallOrderInvoiceRelationServiceImpl.getById(id);
      if(upsmallOrderInvoiceRelation != null){
        upsmallOrderInvoiceRelation = ObjectCopyUtils.copyProperties(smallOrderInvoiceRelation,upsmallOrderInvoiceRelation,true);
      }
      return XfR.ok(smallOrderInvoiceRelationServiceImpl.updateById(upsmallOrderInvoiceRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/smallorderinvoicerelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(smallOrderInvoiceRelationServiceImpl.removeById(id));
  }

  @PostMapping("/smallorderinvoicerelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "small_order_invoice_relation");
     params.put("request", condition);

     return XfR.ok(smallOrderInvoiceRelationServiceImpl.querys(params));
  }

}
