package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialBusinessServeBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialBusinessServeBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-08
 */
@RestController
public class FinancialBusinessServeBillDetailController {

  @Autowired
  private IFinancialBusinessServeBillDetailService financialBusinessServeBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialBusinessServeBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialbusinessservebilldetails" )
  public XfR getFinancialBusinessServeBillDetails(XfPage page, FinancialBusinessServeBillDetail financialBusinessServeBillDetail) {
    return XfR.ok(financialBusinessServeBillDetailServiceImpl.page(page, Wrappers.query(financialBusinessServeBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialbusinessservebilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialBusinessServeBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialBusinessServeBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialbusinessservebilldetails")
  public XfR save(@RequestBody FinancialBusinessServeBillDetail financialBusinessServeBillDetail) {
     return XfR.ok(financialBusinessServeBillDetailServiceImpl.save(financialBusinessServeBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialBusinessServeBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialbusinessservebilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialBusinessServeBillDetail financialBusinessServeBillDetail,@PathVariable Long id) {
      financialBusinessServeBillDetail.setId(id);
      return XfR.ok(financialBusinessServeBillDetailServiceImpl.updateById(financialBusinessServeBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialBusinessServeBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialbusinessservebilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialBusinessServeBillDetail financialBusinessServeBillDetail,@PathVariable Long id) {
      FinancialBusinessServeBillDetail upfinancialBusinessServeBillDetail = financialBusinessServeBillDetailServiceImpl.getById(id);
      if(upfinancialBusinessServeBillDetail != null){
        upfinancialBusinessServeBillDetail = ObjectCopyUtils.copyProperties(financialBusinessServeBillDetail,upfinancialBusinessServeBillDetail,true);
      }
      return XfR.ok(financialBusinessServeBillDetailServiceImpl.updateById(upfinancialBusinessServeBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialbusinessservebilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialBusinessServeBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialbusinessservebilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_business_serve_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialBusinessServeBillDetailServiceImpl.querys(params));
  }

}
