package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialTravelApplyBillDetail;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialTravelApplyBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-08
 */
@RestController
public class FinancialTravelApplyBillDetailController {

  @Autowired
  private IFinancialTravelApplyBillDetailService financialTravelApplyBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialTravelApplyBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialtravelapplybilldetails" )
  public XfR getFinancialTravelApplyBillDetails(XfPage page, FinancialTravelApplyBillDetail financialTravelApplyBillDetail) {
    return XfR.ok(financialTravelApplyBillDetailServiceImpl.page(page, Wrappers.query(financialTravelApplyBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialtravelapplybilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialTravelApplyBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialTravelApplyBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialtravelapplybilldetails")
  public XfR save(@RequestBody FinancialTravelApplyBillDetail financialTravelApplyBillDetail) {
     return XfR.ok(financialTravelApplyBillDetailServiceImpl.save(financialTravelApplyBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialTravelApplyBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialtravelapplybilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialTravelApplyBillDetail financialTravelApplyBillDetail,@PathVariable Long id) {
      financialTravelApplyBillDetail.setId(id);
      return XfR.ok(financialTravelApplyBillDetailServiceImpl.updateById(financialTravelApplyBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialTravelApplyBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialtravelapplybilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialTravelApplyBillDetail financialTravelApplyBillDetail,@PathVariable Long id) {
      FinancialTravelApplyBillDetail upfinancialTravelApplyBillDetail = financialTravelApplyBillDetailServiceImpl.getById(id);
      if(upfinancialTravelApplyBillDetail != null){
        upfinancialTravelApplyBillDetail = ObjectCopyUtils.copyProperties(financialTravelApplyBillDetail,upfinancialTravelApplyBillDetail,true);
      }
      return XfR.ok(financialTravelApplyBillDetailServiceImpl.updateById(upfinancialTravelApplyBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialtravelapplybilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialTravelApplyBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialtravelapplybilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_travel_apply_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialTravelApplyBillDetailServiceImpl.querys(params));
  }

}
