package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.YkbChargeCodeResult;
import com.xforceplus.ultraman.app.financialsettlement.service.IYkbChargeCodeResultService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-08
 */
@RestController
public class YkbChargeCodeResultController {

  @Autowired
  private IYkbChargeCodeResultService ykbChargeCodeResultServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ykbChargeCodeResult ${table.comment}
   * @return
   */
  @GetMapping("/ykbchargecoderesults" )
  public XfR getYkbChargeCodeResults(XfPage page, YkbChargeCodeResult ykbChargeCodeResult) {
    return XfR.ok(ykbChargeCodeResultServiceImpl.page(page, Wrappers.query(ykbChargeCodeResult)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ykbchargecoderesults/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ykbChargeCodeResultServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ykbChargeCodeResult ${table.comment}
   * @return XfR
   */
  @PostMapping("/ykbchargecoderesults")
  public XfR save(@RequestBody YkbChargeCodeResult ykbChargeCodeResult) {
     return XfR.ok(ykbChargeCodeResultServiceImpl.save(ykbChargeCodeResult));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ykbChargeCodeResult ${table.comment}
   * @return XfR
   */
  @PutMapping("/ykbchargecoderesults/{id}")
  public XfR putUpdate(@RequestBody YkbChargeCodeResult ykbChargeCodeResult,@PathVariable Long id) {
      ykbChargeCodeResult.setId(id);
      return XfR.ok(ykbChargeCodeResultServiceImpl.updateById(ykbChargeCodeResult));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ykbChargeCodeResult ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ykbchargecoderesults/{id}")
  public XfR patchUpdate(@RequestBody YkbChargeCodeResult ykbChargeCodeResult,@PathVariable Long id) {
      YkbChargeCodeResult upykbChargeCodeResult = ykbChargeCodeResultServiceImpl.getById(id);
      if(upykbChargeCodeResult != null){
        upykbChargeCodeResult = ObjectCopyUtils.copyProperties(ykbChargeCodeResult,upykbChargeCodeResult,true);
      }
      return XfR.ok(ykbChargeCodeResultServiceImpl.updateById(upykbChargeCodeResult));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ykbchargecoderesults/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ykbChargeCodeResultServiceImpl.removeById(id));
  }

  @PostMapping("/ykbchargecoderesults/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ykb_charge_code_result");
     params.put("request", condition);

     return XfR.ok(ykbChargeCodeResultServiceImpl.querys(params));
  }

}
