package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.AllocationRule;
import com.xforceplus.ultraman.app.financialsettlement.service.IAllocationRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 分摊规则前端控制器
 *
 * @author ultraman
 * @date 2023-12-08
 */
@RestController
public class AllocationRuleController {

  @Autowired
  private IAllocationRuleService allocationRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param allocationRule 分摊规则
   * @return
   */
  @GetMapping("/allocationrules" )
  public XfR getAllocationRules(XfPage page, AllocationRule allocationRule) {
    return XfR.ok(allocationRuleServiceImpl.page(page, Wrappers.query(allocationRule)));
  }

  /**
   * 通过id查询分摊规则
   * @param  id
   * @return XfR
   */
  @GetMapping("/allocationrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(allocationRuleServiceImpl.getById(id));
  }

  /**
   * 新增分摊规则
   * @param allocationRule 分摊规则
   * @return XfR
   */
  @PostMapping("/allocationrules")
  public XfR save(@RequestBody AllocationRule allocationRule) {
     return XfR.ok(allocationRuleServiceImpl.save(allocationRule));
  }

  /**
   * 修改-传入修改后的全部数据分摊规则
   * @param allocationRule 分摊规则
   * @return XfR
   */
  @PutMapping("/allocationrules/{id}")
  public XfR putUpdate(@RequestBody AllocationRule allocationRule,@PathVariable Long id) {
      allocationRule.setId(id);
      return XfR.ok(allocationRuleServiceImpl.updateById(allocationRule));
  }

  /**
   * 修改-传入修改的数据分摊规则
   * @param allocationRule 分摊规则
   * @return XfR
   */
  @PatchMapping("/allocationrules/{id}")
  public XfR patchUpdate(@RequestBody AllocationRule allocationRule,@PathVariable Long id) {
      AllocationRule upallocationRule = allocationRuleServiceImpl.getById(id);
      if(upallocationRule != null){
        upallocationRule = ObjectCopyUtils.copyProperties(allocationRule,upallocationRule,true);
      }
      return XfR.ok(allocationRuleServiceImpl.updateById(upallocationRule));
  }

  /**
   * 通过id删除分摊规则
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/allocationrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(allocationRuleServiceImpl.removeById(id));
  }

  @PostMapping("/allocationrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "allocation_rule");
     params.put("request", condition);

     return XfR.ok(allocationRuleServiceImpl.querys(params));
  }

}
