package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialPurchaseAfterSaleBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialPurchaseAfterSaleBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-08
 */
@RestController
public class FinancialPurchaseAfterSaleBillController {

  @Autowired
  private IFinancialPurchaseAfterSaleBillService financialPurchaseAfterSaleBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPurchaseAfterSaleBill ${table.comment}
   * @return
   */
  @GetMapping("/financialpurchaseaftersalebills" )
  public XfR getFinancialPurchaseAfterSaleBills(XfPage page, FinancialPurchaseAfterSaleBill financialPurchaseAfterSaleBill) {
    return XfR.ok(financialPurchaseAfterSaleBillServiceImpl.page(page, Wrappers.query(financialPurchaseAfterSaleBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpurchaseaftersalebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseAfterSaleBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialPurchaseAfterSaleBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialpurchaseaftersalebills")
  public XfR save(@RequestBody FinancialPurchaseAfterSaleBill financialPurchaseAfterSaleBill) {
     return XfR.ok(financialPurchaseAfterSaleBillServiceImpl.save(financialPurchaseAfterSaleBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialPurchaseAfterSaleBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialpurchaseaftersalebills/{id}")
  public XfR putUpdate(@RequestBody FinancialPurchaseAfterSaleBill financialPurchaseAfterSaleBill,@PathVariable Long id) {
      financialPurchaseAfterSaleBill.setId(id);
      return XfR.ok(financialPurchaseAfterSaleBillServiceImpl.updateById(financialPurchaseAfterSaleBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialPurchaseAfterSaleBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialpurchaseaftersalebills/{id}")
  public XfR patchUpdate(@RequestBody FinancialPurchaseAfterSaleBill financialPurchaseAfterSaleBill,@PathVariable Long id) {
      FinancialPurchaseAfterSaleBill upfinancialPurchaseAfterSaleBill = financialPurchaseAfterSaleBillServiceImpl.getById(id);
      if(upfinancialPurchaseAfterSaleBill != null){
        upfinancialPurchaseAfterSaleBill = ObjectCopyUtils.copyProperties(financialPurchaseAfterSaleBill,upfinancialPurchaseAfterSaleBill,true);
      }
      return XfR.ok(financialPurchaseAfterSaleBillServiceImpl.updateById(upfinancialPurchaseAfterSaleBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpurchaseaftersalebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseAfterSaleBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialpurchaseaftersalebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_purchase_after_sale_bill");
     params.put("request", condition);

     return XfR.ok(financialPurchaseAfterSaleBillServiceImpl.querys(params));
  }

}
