package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FkjBillInfo;
import com.xforceplus.ultraman.app.financialsettlement.service.IFkjBillInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-08
 */
@RestController
public class FkjBillInfoController {

  @Autowired
  private IFkjBillInfoService fkjBillInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fkjBillInfo ${table.comment}
   * @return
   */
  @GetMapping("/fkjbillinfos" )
  public XfR getFkjBillInfos(XfPage page, FkjBillInfo fkjBillInfo) {
    return XfR.ok(fkjBillInfoServiceImpl.page(page, Wrappers.query(fkjBillInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/fkjbillinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fkjBillInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param fkjBillInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/fkjbillinfos")
  public XfR save(@RequestBody FkjBillInfo fkjBillInfo) {
     return XfR.ok(fkjBillInfoServiceImpl.save(fkjBillInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param fkjBillInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/fkjbillinfos/{id}")
  public XfR putUpdate(@RequestBody FkjBillInfo fkjBillInfo,@PathVariable Long id) {
      fkjBillInfo.setId(id);
      return XfR.ok(fkjBillInfoServiceImpl.updateById(fkjBillInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param fkjBillInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/fkjbillinfos/{id}")
  public XfR patchUpdate(@RequestBody FkjBillInfo fkjBillInfo,@PathVariable Long id) {
      FkjBillInfo upfkjBillInfo = fkjBillInfoServiceImpl.getById(id);
      if(upfkjBillInfo != null){
        upfkjBillInfo = ObjectCopyUtils.copyProperties(fkjBillInfo,upfkjBillInfo,true);
      }
      return XfR.ok(fkjBillInfoServiceImpl.updateById(upfkjBillInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fkjbillinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fkjBillInfoServiceImpl.removeById(id));
  }

  @PostMapping("/fkjbillinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fkj_bill_info");
     params.put("request", condition);

     return XfR.ok(fkjBillInfoServiceImpl.querys(params));
  }

}
