package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ReturnMoneyRecordView;
import com.xforceplus.ultraman.app.financialsettlement.service.IReturnMoneyRecordViewService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-08
 */
@RestController
public class ReturnMoneyRecordViewController {

  @Autowired
  private IReturnMoneyRecordViewService returnMoneyRecordViewServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param returnMoneyRecordView ${table.comment}
   * @return
   */
  @GetMapping("/returnmoneyrecordviews" )
  public XfR getReturnMoneyRecordViews(XfPage page, ReturnMoneyRecordView returnMoneyRecordView) {
    return XfR.ok(returnMoneyRecordViewServiceImpl.page(page, Wrappers.query(returnMoneyRecordView)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/returnmoneyrecordviews/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(returnMoneyRecordViewServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param returnMoneyRecordView ${table.comment}
   * @return XfR
   */
  @PostMapping("/returnmoneyrecordviews")
  public XfR save(@RequestBody ReturnMoneyRecordView returnMoneyRecordView) {
     return XfR.ok(returnMoneyRecordViewServiceImpl.save(returnMoneyRecordView));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param returnMoneyRecordView ${table.comment}
   * @return XfR
   */
  @PutMapping("/returnmoneyrecordviews/{id}")
  public XfR putUpdate(@RequestBody ReturnMoneyRecordView returnMoneyRecordView,@PathVariable Long id) {
      returnMoneyRecordView.setId(id);
      return XfR.ok(returnMoneyRecordViewServiceImpl.updateById(returnMoneyRecordView));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param returnMoneyRecordView ${table.comment}
   * @return XfR
   */
  @PatchMapping("/returnmoneyrecordviews/{id}")
  public XfR patchUpdate(@RequestBody ReturnMoneyRecordView returnMoneyRecordView,@PathVariable Long id) {
      ReturnMoneyRecordView upreturnMoneyRecordView = returnMoneyRecordViewServiceImpl.getById(id);
      if(upreturnMoneyRecordView != null){
        upreturnMoneyRecordView = ObjectCopyUtils.copyProperties(returnMoneyRecordView,upreturnMoneyRecordView,true);
      }
      return XfR.ok(returnMoneyRecordViewServiceImpl.updateById(upreturnMoneyRecordView));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/returnmoneyrecordviews/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(returnMoneyRecordViewServiceImpl.removeById(id));
  }

  @PostMapping("/returnmoneyrecordviews/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "return_money_record_view");
     params.put("request", condition);

     return XfR.ok(returnMoneyRecordViewServiceImpl.querys(params));
  }

}
