package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.SettleStaticsOrderRel;
import com.xforceplus.ultraman.app.financialsettlement.service.ISettleStaticsOrderRelService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 结算统计和订单关系前端控制器
 *
 * @author ultraman
 * @date 2023-12-08
 */
@RestController
public class SettleStaticsOrderRelController {

  @Autowired
  private ISettleStaticsOrderRelService settleStaticsOrderRelServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settleStaticsOrderRel 结算统计和订单关系
   * @return
   */
  @GetMapping("/settlestaticsorderrels" )
  public XfR getSettleStaticsOrderRels(XfPage page, SettleStaticsOrderRel settleStaticsOrderRel) {
    return XfR.ok(settleStaticsOrderRelServiceImpl.page(page, Wrappers.query(settleStaticsOrderRel)));
  }

  /**
   * 通过id查询结算统计和订单关系
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlestaticsorderrels/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settleStaticsOrderRelServiceImpl.getById(id));
  }

  /**
   * 新增结算统计和订单关系
   * @param settleStaticsOrderRel 结算统计和订单关系
   * @return XfR
   */
  @PostMapping("/settlestaticsorderrels")
  public XfR save(@RequestBody SettleStaticsOrderRel settleStaticsOrderRel) {
     return XfR.ok(settleStaticsOrderRelServiceImpl.save(settleStaticsOrderRel));
  }

  /**
   * 修改-传入修改后的全部数据结算统计和订单关系
   * @param settleStaticsOrderRel 结算统计和订单关系
   * @return XfR
   */
  @PutMapping("/settlestaticsorderrels/{id}")
  public XfR putUpdate(@RequestBody SettleStaticsOrderRel settleStaticsOrderRel,@PathVariable Long id) {
      settleStaticsOrderRel.setId(id);
      return XfR.ok(settleStaticsOrderRelServiceImpl.updateById(settleStaticsOrderRel));
  }

  /**
   * 修改-传入修改的数据结算统计和订单关系
   * @param settleStaticsOrderRel 结算统计和订单关系
   * @return XfR
   */
  @PatchMapping("/settlestaticsorderrels/{id}")
  public XfR patchUpdate(@RequestBody SettleStaticsOrderRel settleStaticsOrderRel,@PathVariable Long id) {
      SettleStaticsOrderRel upsettleStaticsOrderRel = settleStaticsOrderRelServiceImpl.getById(id);
      if(upsettleStaticsOrderRel != null){
        upsettleStaticsOrderRel = ObjectCopyUtils.copyProperties(settleStaticsOrderRel,upsettleStaticsOrderRel,true);
      }
      return XfR.ok(settleStaticsOrderRelServiceImpl.updateById(upsettleStaticsOrderRel));
  }

  /**
   * 通过id删除结算统计和订单关系
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlestaticsorderrels/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settleStaticsOrderRelServiceImpl.removeById(id));
  }

  @PostMapping("/settlestaticsorderrels/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settle_statics_order_rel");
     params.put("request", condition);

     return XfR.ok(settleStaticsOrderRelServiceImpl.querys(params));
  }

}
