package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ChargeCodeBudgetDetailCall;
import com.xforceplus.ultraman.app.financialsettlement.service.IChargeCodeBudgetDetailCallService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-11
 */
@RestController
public class ChargeCodeBudgetDetailCallController {

  @Autowired
  private IChargeCodeBudgetDetailCallService chargeCodeBudgetDetailCallServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeBudgetDetailCall ${table.comment}
   * @return
   */
  @GetMapping("/chargecodebudgetdetailcalls" )
  public XfR getChargeCodeBudgetDetailCalls(XfPage page, ChargeCodeBudgetDetailCall chargeCodeBudgetDetailCall) {
    return XfR.ok(chargeCodeBudgetDetailCallServiceImpl.page(page, Wrappers.query(chargeCodeBudgetDetailCall)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodebudgetdetailcalls/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetDetailCallServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeCodeBudgetDetailCall ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecodebudgetdetailcalls")
  public XfR save(@RequestBody ChargeCodeBudgetDetailCall chargeCodeBudgetDetailCall) {
     return XfR.ok(chargeCodeBudgetDetailCallServiceImpl.save(chargeCodeBudgetDetailCall));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeCodeBudgetDetailCall ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecodebudgetdetailcalls/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeBudgetDetailCall chargeCodeBudgetDetailCall,@PathVariable Long id) {
      chargeCodeBudgetDetailCall.setId(id);
      return XfR.ok(chargeCodeBudgetDetailCallServiceImpl.updateById(chargeCodeBudgetDetailCall));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeCodeBudgetDetailCall ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecodebudgetdetailcalls/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeBudgetDetailCall chargeCodeBudgetDetailCall,@PathVariable Long id) {
      ChargeCodeBudgetDetailCall upchargeCodeBudgetDetailCall = chargeCodeBudgetDetailCallServiceImpl.getById(id);
      if(upchargeCodeBudgetDetailCall != null){
        upchargeCodeBudgetDetailCall = ObjectCopyUtils.copyProperties(chargeCodeBudgetDetailCall,upchargeCodeBudgetDetailCall,true);
      }
      return XfR.ok(chargeCodeBudgetDetailCallServiceImpl.updateById(upchargeCodeBudgetDetailCall));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodebudgetdetailcalls/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetDetailCallServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodebudgetdetailcalls/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_budget_detail_call");
     params.put("request", condition);

     return XfR.ok(chargeCodeBudgetDetailCallServiceImpl.querys(params));
  }

}
