package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.CustomerArr;
import com.xforceplus.ultraman.app.financialsettlement.service.ICustomerArrService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-11
 */
@RestController
public class CustomerArrController {

  @Autowired
  private ICustomerArrService customerArrServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customerArr ${table.comment}
   * @return
   */
  @GetMapping("/customerarrs" )
  public XfR getCustomerArrs(XfPage page, CustomerArr customerArr) {
    return XfR.ok(customerArrServiceImpl.page(page, Wrappers.query(customerArr)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customerarrs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customerArrServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customerArr ${table.comment}
   * @return XfR
   */
  @PostMapping("/customerarrs")
  public XfR save(@RequestBody CustomerArr customerArr) {
     return XfR.ok(customerArrServiceImpl.save(customerArr));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customerArr ${table.comment}
   * @return XfR
   */
  @PutMapping("/customerarrs/{id}")
  public XfR putUpdate(@RequestBody CustomerArr customerArr,@PathVariable Long id) {
      customerArr.setId(id);
      return XfR.ok(customerArrServiceImpl.updateById(customerArr));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customerArr ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customerarrs/{id}")
  public XfR patchUpdate(@RequestBody CustomerArr customerArr,@PathVariable Long id) {
      CustomerArr upcustomerArr = customerArrServiceImpl.getById(id);
      if(upcustomerArr != null){
        upcustomerArr = ObjectCopyUtils.copyProperties(customerArr,upcustomerArr,true);
      }
      return XfR.ok(customerArrServiceImpl.updateById(upcustomerArr));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customerarrs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customerArrServiceImpl.removeById(id));
  }

  @PostMapping("/customerarrs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customer_arr");
     params.put("request", condition);

     return XfR.ok(customerArrServiceImpl.querys(params));
  }

}
