package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialAssetsBackBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialAssetsBackBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 资产的归还申请单前端控制器
 *
 * @author ultraman
 * @date 2023-12-11
 */
@RestController
public class FinancialAssetsBackBillController {

  @Autowired
  private IFinancialAssetsBackBillService financialAssetsBackBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialAssetsBackBill 资产的归还申请单
   * @return
   */
  @GetMapping("/financialassetsbackbills" )
  public XfR getFinancialAssetsBackBills(XfPage page, FinancialAssetsBackBill financialAssetsBackBill) {
    return XfR.ok(financialAssetsBackBillServiceImpl.page(page, Wrappers.query(financialAssetsBackBill)));
  }

  /**
   * 通过id查询资产的归还申请单
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialassetsbackbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialAssetsBackBillServiceImpl.getById(id));
  }

  /**
   * 新增资产的归还申请单
   * @param financialAssetsBackBill 资产的归还申请单
   * @return XfR
   */
  @PostMapping("/financialassetsbackbills")
  public XfR save(@RequestBody FinancialAssetsBackBill financialAssetsBackBill) {
     return XfR.ok(financialAssetsBackBillServiceImpl.save(financialAssetsBackBill));
  }

  /**
   * 修改-传入修改后的全部数据资产的归还申请单
   * @param financialAssetsBackBill 资产的归还申请单
   * @return XfR
   */
  @PutMapping("/financialassetsbackbills/{id}")
  public XfR putUpdate(@RequestBody FinancialAssetsBackBill financialAssetsBackBill,@PathVariable Long id) {
      financialAssetsBackBill.setId(id);
      return XfR.ok(financialAssetsBackBillServiceImpl.updateById(financialAssetsBackBill));
  }

  /**
   * 修改-传入修改的数据资产的归还申请单
   * @param financialAssetsBackBill 资产的归还申请单
   * @return XfR
   */
  @PatchMapping("/financialassetsbackbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialAssetsBackBill financialAssetsBackBill,@PathVariable Long id) {
      FinancialAssetsBackBill upfinancialAssetsBackBill = financialAssetsBackBillServiceImpl.getById(id);
      if(upfinancialAssetsBackBill != null){
        upfinancialAssetsBackBill = ObjectCopyUtils.copyProperties(financialAssetsBackBill,upfinancialAssetsBackBill,true);
      }
      return XfR.ok(financialAssetsBackBillServiceImpl.updateById(upfinancialAssetsBackBill));
  }

  /**
   * 通过id删除资产的归还申请单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialassetsbackbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialAssetsBackBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialassetsbackbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_assets_back_bill");
     params.put("request", condition);

     return XfR.ok(financialAssetsBackBillServiceImpl.querys(params));
  }

}
