package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialPurchaseBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialPurchaseBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-11
 */
@RestController
public class FinancialPurchaseBillController {

  @Autowired
  private IFinancialPurchaseBillService financialPurchaseBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPurchaseBill ${table.comment}
   * @return
   */
  @GetMapping("/financialpurchasebills" )
  public XfR getFinancialPurchaseBills(XfPage page, FinancialPurchaseBill financialPurchaseBill) {
    return XfR.ok(financialPurchaseBillServiceImpl.page(page, Wrappers.query(financialPurchaseBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpurchasebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialPurchaseBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialpurchasebills")
  public XfR save(@RequestBody FinancialPurchaseBill financialPurchaseBill) {
     return XfR.ok(financialPurchaseBillServiceImpl.save(financialPurchaseBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialPurchaseBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialpurchasebills/{id}")
  public XfR putUpdate(@RequestBody FinancialPurchaseBill financialPurchaseBill,@PathVariable Long id) {
      financialPurchaseBill.setId(id);
      return XfR.ok(financialPurchaseBillServiceImpl.updateById(financialPurchaseBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialPurchaseBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialpurchasebills/{id}")
  public XfR patchUpdate(@RequestBody FinancialPurchaseBill financialPurchaseBill,@PathVariable Long id) {
      FinancialPurchaseBill upfinancialPurchaseBill = financialPurchaseBillServiceImpl.getById(id);
      if(upfinancialPurchaseBill != null){
        upfinancialPurchaseBill = ObjectCopyUtils.copyProperties(financialPurchaseBill,upfinancialPurchaseBill,true);
      }
      return XfR.ok(financialPurchaseBillServiceImpl.updateById(upfinancialPurchaseBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpurchasebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialpurchasebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_purchase_bill");
     params.put("request", condition);

     return XfR.ok(financialPurchaseBillServiceImpl.querys(params));
  }

}
