package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.CostTypeOrgMapping;
import com.xforceplus.ultraman.app.financialsettlement.service.ICostTypeOrgMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-12
 */
@RestController
public class CostTypeOrgMappingController {

  @Autowired
  private ICostTypeOrgMappingService costTypeOrgMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param costTypeOrgMapping ${table.comment}
   * @return
   */
  @GetMapping("/costtypeorgmappings" )
  public XfR getCostTypeOrgMappings(XfPage page, CostTypeOrgMapping costTypeOrgMapping) {
    return XfR.ok(costTypeOrgMappingServiceImpl.page(page, Wrappers.query(costTypeOrgMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/costtypeorgmappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(costTypeOrgMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param costTypeOrgMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/costtypeorgmappings")
  public XfR save(@RequestBody CostTypeOrgMapping costTypeOrgMapping) {
     return XfR.ok(costTypeOrgMappingServiceImpl.save(costTypeOrgMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param costTypeOrgMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/costtypeorgmappings/{id}")
  public XfR putUpdate(@RequestBody CostTypeOrgMapping costTypeOrgMapping,@PathVariable Long id) {
      costTypeOrgMapping.setId(id);
      return XfR.ok(costTypeOrgMappingServiceImpl.updateById(costTypeOrgMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param costTypeOrgMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/costtypeorgmappings/{id}")
  public XfR patchUpdate(@RequestBody CostTypeOrgMapping costTypeOrgMapping,@PathVariable Long id) {
      CostTypeOrgMapping upcostTypeOrgMapping = costTypeOrgMappingServiceImpl.getById(id);
      if(upcostTypeOrgMapping != null){
        upcostTypeOrgMapping = ObjectCopyUtils.copyProperties(costTypeOrgMapping,upcostTypeOrgMapping,true);
      }
      return XfR.ok(costTypeOrgMappingServiceImpl.updateById(upcostTypeOrgMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/costtypeorgmappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(costTypeOrgMappingServiceImpl.removeById(id));
  }

  @PostMapping("/costtypeorgmappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cost_type_org_mapping");
     params.put("request", condition);

     return XfR.ok(costTypeOrgMappingServiceImpl.querys(params));
  }

}
