package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialRefundBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialRefundBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 退款申请单前端控制器
 *
 * @author ultraman
 * @date 2023-12-12
 */
@RestController
public class FinancialRefundBillController {

  @Autowired
  private IFinancialRefundBillService financialRefundBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialRefundBill 退款申请单
   * @return
   */
  @GetMapping("/financialrefundbills" )
  public XfR getFinancialRefundBills(XfPage page, FinancialRefundBill financialRefundBill) {
    return XfR.ok(financialRefundBillServiceImpl.page(page, Wrappers.query(financialRefundBill)));
  }

  /**
   * 通过id查询退款申请单
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialrefundbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialRefundBillServiceImpl.getById(id));
  }

  /**
   * 新增退款申请单
   * @param financialRefundBill 退款申请单
   * @return XfR
   */
  @PostMapping("/financialrefundbills")
  public XfR save(@RequestBody FinancialRefundBill financialRefundBill) {
     return XfR.ok(financialRefundBillServiceImpl.save(financialRefundBill));
  }

  /**
   * 修改-传入修改后的全部数据退款申请单
   * @param financialRefundBill 退款申请单
   * @return XfR
   */
  @PutMapping("/financialrefundbills/{id}")
  public XfR putUpdate(@RequestBody FinancialRefundBill financialRefundBill,@PathVariable Long id) {
      financialRefundBill.setId(id);
      return XfR.ok(financialRefundBillServiceImpl.updateById(financialRefundBill));
  }

  /**
   * 修改-传入修改的数据退款申请单
   * @param financialRefundBill 退款申请单
   * @return XfR
   */
  @PatchMapping("/financialrefundbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialRefundBill financialRefundBill,@PathVariable Long id) {
      FinancialRefundBill upfinancialRefundBill = financialRefundBillServiceImpl.getById(id);
      if(upfinancialRefundBill != null){
        upfinancialRefundBill = ObjectCopyUtils.copyProperties(financialRefundBill,upfinancialRefundBill,true);
      }
      return XfR.ok(financialRefundBillServiceImpl.updateById(upfinancialRefundBill));
  }

  /**
   * 通过id删除退款申请单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialrefundbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialRefundBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialrefundbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_refund_bill");
     params.put("request", condition);

     return XfR.ok(financialRefundBillServiceImpl.querys(params));
  }

}
