package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialShareInfo;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialShareInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-12
 */
@RestController
public class FinancialShareInfoController {

  @Autowired
  private IFinancialShareInfoService financialShareInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialShareInfo ${table.comment}
   * @return
   */
  @GetMapping("/financialshareinfos" )
  public XfR getFinancialShareInfos(XfPage page, FinancialShareInfo financialShareInfo) {
    return XfR.ok(financialShareInfoServiceImpl.page(page, Wrappers.query(financialShareInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialshareinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialShareInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialShareInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialshareinfos")
  public XfR save(@RequestBody FinancialShareInfo financialShareInfo) {
     return XfR.ok(financialShareInfoServiceImpl.save(financialShareInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialShareInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialshareinfos/{id}")
  public XfR putUpdate(@RequestBody FinancialShareInfo financialShareInfo,@PathVariable Long id) {
      financialShareInfo.setId(id);
      return XfR.ok(financialShareInfoServiceImpl.updateById(financialShareInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialShareInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialshareinfos/{id}")
  public XfR patchUpdate(@RequestBody FinancialShareInfo financialShareInfo,@PathVariable Long id) {
      FinancialShareInfo upfinancialShareInfo = financialShareInfoServiceImpl.getById(id);
      if(upfinancialShareInfo != null){
        upfinancialShareInfo = ObjectCopyUtils.copyProperties(financialShareInfo,upfinancialShareInfo,true);
      }
      return XfR.ok(financialShareInfoServiceImpl.updateById(upfinancialShareInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialshareinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialShareInfoServiceImpl.removeById(id));
  }

  @PostMapping("/financialshareinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_share_info");
     params.put("request", condition);

     return XfR.ok(financialShareInfoServiceImpl.querys(params));
  }

}
