package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.BugetItems;
import com.xforceplus.ultraman.app.financialsettlement.service.IBugetItemsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class BugetItemsController {

  @Autowired
  private IBugetItemsService bugetItemsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bugetItems ${table.comment}
   * @return
   */
  @GetMapping("/bugetitemss" )
  public XfR getBugetItemss(XfPage page, BugetItems bugetItems) {
    return XfR.ok(bugetItemsServiceImpl.page(page, Wrappers.query(bugetItems)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bugetitemss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bugetItemsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bugetItems ${table.comment}
   * @return XfR
   */
  @PostMapping("/bugetitemss")
  public XfR save(@RequestBody BugetItems bugetItems) {
     return XfR.ok(bugetItemsServiceImpl.save(bugetItems));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bugetItems ${table.comment}
   * @return XfR
   */
  @PutMapping("/bugetitemss/{id}")
  public XfR putUpdate(@RequestBody BugetItems bugetItems,@PathVariable Long id) {
      bugetItems.setId(id);
      return XfR.ok(bugetItemsServiceImpl.updateById(bugetItems));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bugetItems ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bugetitemss/{id}")
  public XfR patchUpdate(@RequestBody BugetItems bugetItems,@PathVariable Long id) {
      BugetItems upbugetItems = bugetItemsServiceImpl.getById(id);
      if(upbugetItems != null){
        upbugetItems = ObjectCopyUtils.copyProperties(bugetItems,upbugetItems,true);
      }
      return XfR.ok(bugetItemsServiceImpl.updateById(upbugetItems));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bugetitemss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bugetItemsServiceImpl.removeById(id));
  }

  @PostMapping("/bugetitemss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "buget_items");
     params.put("request", condition);

     return XfR.ok(bugetItemsServiceImpl.querys(params));
  }

}
