package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.ChargeGivenRelation;
import com.xforceplus.ultraman.app.financialsettlement.service.IChargeGivenRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 综合关系表-(废弃)前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class ChargeGivenRelationController {

  @Autowired
  private IChargeGivenRelationService chargeGivenRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeGivenRelation 综合关系表-(废弃)
   * @return
   */
  @GetMapping("/chargegivenrelations" )
  public XfR getChargeGivenRelations(XfPage page, ChargeGivenRelation chargeGivenRelation) {
    return XfR.ok(chargeGivenRelationServiceImpl.page(page, Wrappers.query(chargeGivenRelation)));
  }

  /**
   * 通过id查询综合关系表-(废弃)
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargegivenrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeGivenRelationServiceImpl.getById(id));
  }

  /**
   * 新增综合关系表-(废弃)
   * @param chargeGivenRelation 综合关系表-(废弃)
   * @return XfR
   */
  @PostMapping("/chargegivenrelations")
  public XfR save(@RequestBody ChargeGivenRelation chargeGivenRelation) {
     return XfR.ok(chargeGivenRelationServiceImpl.save(chargeGivenRelation));
  }

  /**
   * 修改-传入修改后的全部数据综合关系表-(废弃)
   * @param chargeGivenRelation 综合关系表-(废弃)
   * @return XfR
   */
  @PutMapping("/chargegivenrelations/{id}")
  public XfR putUpdate(@RequestBody ChargeGivenRelation chargeGivenRelation,@PathVariable Long id) {
      chargeGivenRelation.setId(id);
      return XfR.ok(chargeGivenRelationServiceImpl.updateById(chargeGivenRelation));
  }

  /**
   * 修改-传入修改的数据综合关系表-(废弃)
   * @param chargeGivenRelation 综合关系表-(废弃)
   * @return XfR
   */
  @PatchMapping("/chargegivenrelations/{id}")
  public XfR patchUpdate(@RequestBody ChargeGivenRelation chargeGivenRelation,@PathVariable Long id) {
      ChargeGivenRelation upchargeGivenRelation = chargeGivenRelationServiceImpl.getById(id);
      if(upchargeGivenRelation != null){
        upchargeGivenRelation = ObjectCopyUtils.copyProperties(chargeGivenRelation,upchargeGivenRelation,true);
      }
      return XfR.ok(chargeGivenRelationServiceImpl.updateById(upchargeGivenRelation));
  }

  /**
   * 通过id删除综合关系表-(废弃)
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargegivenrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeGivenRelationServiceImpl.removeById(id));
  }

  @PostMapping("/chargegivenrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_given_relation");
     params.put("request", condition);

     return XfR.ok(chargeGivenRelationServiceImpl.querys(params));
  }

}
