package com.xforceplus.ultraman.app.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialAssembleBill;
import com.xforceplus.ultraman.app.financialsettlement.service.IFinancialAssembleBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class FinancialAssembleBillController {

  @Autowired
  private IFinancialAssembleBillService financialAssembleBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialAssembleBill ${table.comment}
   * @return
   */
  @GetMapping("/financialassemblebills" )
  public XfR getFinancialAssembleBills(XfPage page, FinancialAssembleBill financialAssembleBill) {
    return XfR.ok(financialAssembleBillServiceImpl.page(page, Wrappers.query(financialAssembleBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialassemblebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialAssembleBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialAssembleBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialassemblebills")
  public XfR save(@RequestBody FinancialAssembleBill financialAssembleBill) {
     return XfR.ok(financialAssembleBillServiceImpl.save(financialAssembleBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialAssembleBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialassemblebills/{id}")
  public XfR putUpdate(@RequestBody FinancialAssembleBill financialAssembleBill,@PathVariable Long id) {
      financialAssembleBill.setId(id);
      return XfR.ok(financialAssembleBillServiceImpl.updateById(financialAssembleBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialAssembleBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialassemblebills/{id}")
  public XfR patchUpdate(@RequestBody FinancialAssembleBill financialAssembleBill,@PathVariable Long id) {
      FinancialAssembleBill upfinancialAssembleBill = financialAssembleBillServiceImpl.getById(id);
      if(upfinancialAssembleBill != null){
        upfinancialAssembleBill = ObjectCopyUtils.copyProperties(financialAssembleBill,upfinancialAssembleBill,true);
      }
      return XfR.ok(financialAssembleBillServiceImpl.updateById(upfinancialAssembleBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialassemblebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialAssembleBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialassemblebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_assemble_bill");
     params.put("request", condition);

     return XfR.ok(financialAssembleBillServiceImpl.querys(params));
  }

}
